-- seed_permission_profiles.sql
USE financeiro;

INSERT IGNORE INTO permission_profiles (name, is_active) VALUES
('Admin', 1),
('Financeiro', 1),
('Leitura', 1);

SET @p_admin = (SELECT id FROM permission_profiles WHERE name='Admin' LIMIT 1);
SET @p_fin   = (SELECT id FROM permission_profiles WHERE name='Financeiro' LIMIT 1);
SET @p_read  = (SELECT id FROM permission_profiles WHERE name='Leitura' LIMIT 1);

-- ADMIN
INSERT INTO profile_permissions (profile_id, perm_key, can_view, can_create, can_edit, can_delete) VALUES
(@p_admin,'dashboard',1,1,1,1),
(@p_admin,'banks',1,1,1,1),
(@p_admin,'parties',1,1,1,1),
(@p_admin,'parties_import',1,1,1,1),
(@p_admin,'contas_pagar',1,1,1,1),
(@p_admin,'contas_receber',1,1,1,1),
(@p_admin,'categories',1,1,1,1),
(@p_admin,'cost_centers',1,1,1,1),
(@p_admin,'accounts',1,1,1,1),
(@p_admin,'dre',1,1,1,1),
(@p_admin,'reconcile',1,1,1,1),
(@p_admin,'assistant_ai',1,1,1,1),
(@p_admin,'prompt_categories',1,1,1,1),
(@p_admin,'prompts',1,1,1,1),
(@p_admin,'ia_settings',1,1,1,1),
(@p_admin,'settings',1,1,1,1),
(@p_admin,'users',1,1,1,1),
(@p_admin,'permission_profiles',1,1,1,1),
(@p_admin,'audit_logs',1,1,1,1)
ON DUPLICATE KEY UPDATE
can_view=VALUES(can_view), can_create=VALUES(can_create), can_edit=VALUES(can_edit), can_delete=VALUES(can_delete);

-- FINANCEIRO
INSERT INTO profile_permissions (profile_id, perm_key, can_view, can_create, can_edit, can_delete) VALUES
(@p_fin,'dashboard',1,0,0,0),
(@p_fin,'banks',1,1,1,1),
(@p_fin,'parties',1,1,1,1),
(@p_fin,'parties_import',1,1,0,0),
(@p_fin,'contas_pagar',1,1,1,1),
(@p_fin,'contas_receber',1,1,1,1),
(@p_fin,'categories',1,1,1,0),
(@p_fin,'cost_centers',1,1,1,0),
(@p_fin,'accounts',1,1,1,0),
(@p_fin,'dre',1,0,0,0),
(@p_fin,'reconcile',1,1,1,0),
(@p_fin,'assistant_ai',1,1,0,0),
(@p_fin,'prompt_categories',1,1,1,0),
(@p_fin,'prompts',1,1,1,0),
(@p_fin,'ia_settings',0,0,0,0),
(@p_fin,'settings',0,0,0,0),
(@p_fin,'users',0,0,0,0),
(@p_fin,'permission_profiles',0,0,0,0),
(@p_fin,'audit_logs',0,0,0,0)
ON DUPLICATE KEY UPDATE
can_view=VALUES(can_view), can_create=VALUES(can_create), can_edit=VALUES(can_edit), can_delete=VALUES(can_delete);

-- LEITURA
INSERT INTO profile_permissions (profile_id, perm_key, can_view, can_create, can_edit, can_delete) VALUES
(@p_read,'dashboard',1,0,0,0),
(@p_read,'banks',1,0,0,0),
(@p_read,'parties',1,0,0,0),
(@p_read,'parties_import',0,0,0,0),
(@p_read,'contas_pagar',1,0,0,0),
(@p_read,'contas_receber',1,0,0,0),
(@p_read,'categories',1,0,0,0),
(@p_read,'cost_centers',1,0,0,0),
(@p_read,'accounts',1,0,0,0),
(@p_read,'dre',1,0,0,0),
(@p_read,'reconcile',1,0,0,0),
(@p_read,'assistant_ai',1,0,0,0),
(@p_read,'prompt_categories',0,0,0,0),
(@p_read,'prompts',0,0,0,0),
(@p_read,'ia_settings',0,0,0,0),
(@p_read,'settings',0,0,0,0),
(@p_read,'users',0,0,0,0),
(@p_read,'permission_profiles',0,0,0,0),
(@p_read,'audit_logs',0,0,0,0)
ON DUPLICATE KEY UPDATE
can_view=VALUES(can_view), can_create=VALUES(can_create), can_edit=VALUES(can_edit), can_delete=VALUES(can_delete);
