<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin');
require_perm('users','view');

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

// Módulos (perm_key) do sistema
$modules = [
  ['key'=>'dashboard', 'label'=>'Dashboard'],
  ['key'=>'banks', 'label'=>'Bancos'],
  ['key'=>'parties', 'label'=>'Clientes/Fornecedores'],
  ['key'=>'parties_import', 'label'=>'Importar CSV'],
  ['key'=>'contas_pagar', 'label'=>'Contas a Pagar'],
  ['key'=>'contas_receber', 'label'=>'Contas a Receber'],
  ['key'=>'categories', 'label'=>'Categorias'],
  ['key'=>'cost_centers', 'label'=>'Centros de Custo'],
  ['key'=>'accounts', 'label'=>'Plano de Contas'],
  ['key'=>'dre', 'label'=>'DRE'],
  ['key'=>'reconcile', 'label'=>'Conciliação'],
  ['key'=>'assistant_ai', 'label'=>'Assistente IA'],
  ['key'=>'prompt_categories', 'label'=>'Categorias Prompt'],
  ['key'=>'prompts', 'label'=>'Prompts'],
  ['key'=>'ia_settings', 'label'=>'Config IA (APIs)'],
  ['key'=>'settings', 'label'=>'Configurações (branding/SMTP)'],
  ['key'=>'users', 'label'=>'Usuários'],
  ['key'=>'permission_profiles', 'label'=>'Perfis de acesso'],
  ['key'=>'audit_logs', 'label'=>'Auditoria'],
];

function perms_for_user(PDO $pdo, int $uid): array {
  $st = $pdo->prepare("SELECT perm_key, can_view, can_create, can_edit, can_delete FROM user_permissions WHERE user_id=?");
  $st->execute([$uid]);
  $m = [];
  foreach ($st->fetchAll() as $r) {
    $m[$r['perm_key']] = [
      'view'=>(int)$r['can_view']===1,
      'create'=>(int)$r['can_create']===1,
      'edit'=>(int)$r['can_edit']===1,
      'delete'=>(int)$r['can_delete']===1,
    ];
  }
  return $m;
}

function seed_default_permissions(PDO $pdo, int $uid, string $role, array $modules): void {
  $pdo->prepare("DELETE FROM user_permissions WHERE user_id=?")->execute([$uid]);
  $ins = $pdo->prepare("
    INSERT INTO user_permissions (user_id, perm_key, can_view, can_create, can_edit, can_delete)
    VALUES (?,?,?,?,?,?)
  ");

  foreach ($modules as $m) {
    $k = $m['key'];
    $v=$c=$e=$d=0;

    if ($role === 'read') {
      $v = 1;
      // leitura: não permite editar nada
    } elseif ($role === 'finance') {
      // Financeiro: opera rotinas financeiras e IA; sem admin/config
      $v = 1;

      if (in_array($k, ['banks','parties','parties_import','contas_pagar','contas_receber','categories','cost_centers','accounts','dre','reconcile','assistant_ai','prompt_categories','prompts'], true)) {
        $c = 1; $e = 1;
      }
      if (in_array($k, ['banks','parties','contas_pagar','contas_receber'], true)) {
        $d = 1;
      }
      if (in_array($k, ['settings','ia_settings','users','permission_profiles','audit_logs'], true)) {
        $v=0; $c=0; $e=0; $d=0;
      }
    } else {
      // admin
      $v=$c=$e=$d=1;
    }

    $ins->execute([$uid,$k,$v,$c,$e,$d]);
  }
}

function apply_profile_permissions(PDO $pdo, int $uid, int $profileId): void {
  $pdo->prepare("DELETE FROM user_permissions WHERE user_id=?")->execute([$uid]);
  $st = $pdo->prepare("SELECT perm_key, can_view, can_create, can_edit, can_delete FROM profile_permissions WHERE profile_id=?");
  $st->execute([$profileId]);
  $ins = $pdo->prepare("INSERT INTO user_permissions (user_id, perm_key, can_view, can_create, can_edit, can_delete) VALUES (?,?,?,?,?,?)");
  foreach ($st->fetchAll() as $r) {
    $ins->execute([$uid, $r['perm_key'], (int)$r['can_view'], (int)$r['can_create'], (int)$r['can_edit'], (int)$r['can_delete']]);
  }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if ($action === 'create') {
      require_perm('users','create');

      $name = trim($_POST['name'] ?? '');
      $email = trim($_POST['email'] ?? '');
      $role = $_POST['role'] ?? 'read';
      $pass = $_POST['password'] ?? '';
      $is_active = (int)($_POST['is_active'] ?? 1);

      if ($name==='' || $email==='') throw new Exception('Nome e e-mail são obrigatórios.');
      if (!in_array($role, ['admin','finance','read'], true)) $role='read';
      if (strlen($pass) < 8) throw new Exception('Senha mínima: 8 caracteres.');

      $stc = $pdo->prepare("SELECT COUNT(*) FROM users WHERE LOWER(email)=LOWER(?)");
      $stc->execute([$email]);
      if ((int)$stc->fetchColumn() > 0) throw new Exception('E-mail já cadastrado.');

      $pdo->beginTransaction();
      $pdo->prepare("INSERT INTO users (name,email,password_hash,role,is_active) VALUES (?,?,?,?,?)")
          ->execute([$name,$email,password_hash($pass, PASSWORD_BCRYPT),$role,$is_active]);
      $uid = (int)$pdo->lastInsertId();

      seed_default_permissions($pdo, $uid, $role, $modules);

      if (function_exists('audit_log')) audit_log('create','user',$uid,['email'=>$email,'role'=>$role]);
      if (function_exists('perm_history_log')) perm_history_log('user',$uid,'preset',['role'=>$role]);

      $pdo->commit();
      redirect('/users.php?msg=Usuário criado');
    }

    if ($action === 'edit') {
      require_perm('users','edit');

      $uid = (int)($_POST['id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $email = trim($_POST['email'] ?? '');
      $role = $_POST['role'] ?? 'read';
      $is_active = (int)($_POST['is_active'] ?? 1);
      $newpass = $_POST['new_password'] ?? '';
      $profileId = (int)($_POST['profile_id'] ?? 0);
      $applyPreset = $_POST['apply_preset'] ?? '';

      if ($uid<=0) throw new Exception('ID inválido.');
      if ($name==='' || $email==='') throw new Exception('Nome e e-mail são obrigatórios.');
      if (!in_array($role, ['admin','finance','read'], true)) $role='read';

      $stc = $pdo->prepare("SELECT COUNT(*) FROM users WHERE LOWER(email)=LOWER(?) AND id<>?");
      $stc->execute([$email,$uid]);
      if ((int)$stc->fetchColumn() > 0) throw new Exception('E-mail já cadastrado.');

      $pdo->beginTransaction();

      // Atualiza user
      $pdo->prepare("UPDATE users SET name=?, email=?, role=?, is_active=?, profile_id=? WHERE id=?")
          ->execute([$name,$email,$role,$is_active, ($profileId>0?$profileId:null), $uid]);

      if ($newpass !== '') {
        if (strlen($newpass) < 8) throw new Exception('Senha mínima: 8 caracteres.');
        $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")
            ->execute([password_hash($newpass, PASSWORD_BCRYPT),$uid]);
      }

      // Preset (substitui permissões)
      if ($applyPreset !== '') {
        if (!in_array($applyPreset, ['read','finance','admin'], true)) $applyPreset = 'read';
        $pdo->prepare("UPDATE users SET role=? WHERE id=?")->execute([$applyPreset, $uid]);
        seed_default_permissions($pdo, $uid, $applyPreset, $modules);
        if (function_exists('perm_history_log')) perm_history_log('user',$uid,'preset',['role'=>$applyPreset]);
        if (function_exists('audit_log')) audit_log('edit','user',$uid,['preset'=>$applyPreset]);
        $pdo->commit();
        redirect('/users.php?msg=Preset aplicado');
      }

      // Se selecionou profile_id, herda do perfil; senão usa checkboxes da tela
      if ($profileId > 0) {
        apply_profile_permissions($pdo, $uid, $profileId);
        if (function_exists('perm_history_log')) perm_history_log('user',$uid,'profile_apply',['profile_id'=>$profileId]);
      } else {
        // permissões custom
        $pdo->prepare("DELETE FROM user_permissions WHERE user_id=?")->execute([$uid]);
        $ins = $pdo->prepare("INSERT INTO user_permissions (user_id, perm_key, can_view, can_create, can_edit, can_delete) VALUES (?,?,?,?,?,?)");
        foreach ($modules as $m) {
          $k = $m['key'];
          $v = isset($_POST["p_{$k}_v"]) ? 1 : 0;
          $c = isset($_POST["p_{$k}_c"]) ? 1 : 0;
          $e = isset($_POST["p_{$k}_e"]) ? 1 : 0;
          $d = isset($_POST["p_{$k}_d"]) ? 1 : 0;
          if ($v === 0) { $c=0; $e=0; $d=0; }
          $ins->execute([$uid,$k,$v,$c,$e,$d]);
        }
        if (function_exists('perm_history_log')) perm_history_log('user',$uid,'manual',['role'=>$role]);
      }

      if (function_exists('audit_log')) audit_log('edit','user',$uid,['email'=>$email,'role'=>$role,'profile_id'=>$profileId]);
      $pdo->commit();
      redirect('/users.php?msg=Usuário atualizado');
    }
  } catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    $err = $e->getMessage();
  }
}

render_header('Usuários');

if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if ($action === 'new') { ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Novo usuário</h3>
    <a class="btn btn-secondary" href="users.php">Voltar</a>
  </div>

  <form method="post" action="users.php?action=create" class="card shadow-sm p-3" style="max-width:920px">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row g-3">
      <div class="col-md-4"><label class="form-label">Nome</label><input class="form-control" name="name" required></div>
      <div class="col-md-4"><label class="form-label">E-mail</label><input class="form-control" name="email" type="email" required></div>
      <div class="col-md-2"><label class="form-label">Perfil</label>
        <select class="form-select" name="role">
          <option value="read">Leitura</option>
          <option value="finance">Financeiro</option>
          <option value="admin">Admin</option>
        </select>
      </div>
      <div class="col-md-2"><label class="form-label">Ativo?</label>
        <select class="form-select" name="is_active"><option value="1" selected>Sim</option><option value="0">Não</option></select>
      </div>
      <div class="col-md-4"><label class="form-label">Senha</label><input class="form-control" name="password" type="password" required><div class="form-text">Mínimo 8 caracteres.</div></div>
    </div>
    <div class="mt-3 d-flex gap-2"><button class="btn btn-primary">Criar</button><a class="btn btn-secondary" href="users.php">Cancelar</a></div>
  </form>
<?php render_footer(); exit; }

if ($action === 'editform') {
  $uid=(int)($_GET['id'] ?? 0);
  $st=$pdo->prepare("SELECT id,name,email,role,is_active,profile_id FROM users WHERE id=?");
  $st->execute([$uid]);
  $u=$st->fetch();
  if(!$u){ echo '<div class="alert alert-danger">Usuário não encontrado.</div>'; render_footer(); exit; }

  $perms = perms_for_user($pdo, $uid);
  $profiles = [];
  try {
    $profiles = $pdo->query("SELECT id,name FROM permission_profiles WHERE is_active=1 ORDER BY name")->fetchAll();
  } catch(Throwable $e) { $profiles=[]; }
?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Editar usuário</h3>
    <a class="btn btn-secondary" href="users.php">Voltar</a>
  </div>

  <form method="post" action="users.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$u['id'])?>">

    <div class="row g-3">
      <div class="col-md-4"><label class="form-label">Nome</label><input class="form-control" name="name" value="<?=h($u['name'])?>" required></div>
      <div class="col-md-4"><label class="form-label">E-mail</label><input class="form-control" name="email" type="email" value="<?=h($u['email'])?>" required></div>
      <div class="col-md-2"><label class="form-label">Perfil</label>
        <select class="form-select" name="role">
          <option value="read" <?=$u['role']==='read'?'selected':''?>>Leitura</option>
          <option value="finance" <?=$u['role']==='finance'?'selected':''?>>Financeiro</option>
          <option value="admin" <?=$u['role']==='admin'?'selected':''?>>Admin</option>
        </select>
      </div>
      <div class="col-md-2"><label class="form-label">Ativo?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=(int)$u['is_active']===1?'selected':''?>>Sim</option>
          <option value="0" <?=(int)$u['is_active']===0?'selected':''?>>Não</option>
        </select>
      </div>

      <div class="col-md-4"><label class="form-label">Nova senha (opcional)</label><input class="form-control" name="new_password" type="password"></div>

      <div class="col-md-8">
        <label class="form-label">Perfil de acesso (template)</label>
        <select class="form-select" name="profile_id">
          <option value="0">— Sem perfil (permissões abaixo)</option>
          <?php foreach($profiles as $pr): ?>
            <option value="<?=$pr['id']?>" <?=((int)($u['profile_id'] ?? 0)===(int)$pr['id'])?'selected':''?>><?=h($pr['name'])?></option>
          <?php endforeach; ?>
        </select>
        <div class="form-text">Se selecionar, o usuário herda permissões do perfil.</div>
      </div>
    </div>

    <hr class="my-4">

    <div class="d-flex justify-content-between align-items-center mb-2">
      <h5 class="mb-0">Permissões</h5>
      <div class="d-flex flex-wrap gap-2">
        <button class="btn btn-sm btn-outline-dark" name="apply_preset" value="read" onclick="return confirm('Aplicar preset LEITURA?');">Preset: Leitura</button>
        <button class="btn btn-sm btn-outline-dark" name="apply_preset" value="finance" onclick="return confirm('Aplicar preset FINANCEIRO?');">Preset: Financeiro</button>
        <button class="btn btn-sm btn-outline-dark" name="apply_preset" value="admin" onclick="return confirm('Aplicar preset ADMIN?');">Preset: Admin</button>
      </div>
    </div>

    <div class="table-responsive">
      <table class="table table-sm table-striped align-middle mb-0" id="permTable">
        <thead class="table-dark"><tr><th>Módulo</th><th class="text-center">Ver</th><th class="text-center">Incluir</th><th class="text-center">Editar</th><th class="text-center">Excluir</th></tr></thead>
        <tbody>
          <?php foreach($modules as $m):
            $k=$m['key'];
            $p=$perms[$k] ?? ['view'=>false,'create'=>false,'edit'=>false,'delete'=>false];
          ?>
            <tr>
              <td><?=h($m['label'])?></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_v" <?=$p['view']?'checked':''?>></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_c" <?=$p['create']?'checked':''?>></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_e" <?=$p['edit']?'checked':''?>></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_d" <?=$p['delete']?'checked':''?>></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <script>
      (function(){
        const sel = document.querySelector('select[name="profile_id"]');
        const table = document.getElementById('permTable');
        function apply(){
          const v = parseInt(sel.value||'0',10);
          const disabled = v>0;
          table.querySelectorAll('input[type="checkbox"]').forEach(cb=> cb.disabled = disabled);
        }
        sel.addEventListener('change', apply);
        apply();
      })();
    </script>

    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="users.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

$users=$pdo->query("SELECT id,name,email,role,is_active,created_at FROM users ORDER BY created_at DESC")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Usuários do sistema</h3>
  <?php if (perm_can('users','create')): ?>
    <a class="btn btn-primary" href="users.php?action=new">+ Novo usuário</a>
  <?php endif; ?>
</div>

<div class="row g-3">
  <?php foreach($users as $u): ?>
    <div class="col-md-4">
      <div class="list-card" data-tilt>
        <div class="d-flex justify-content-between align-items-start gap-2">
          <div><div class="list-title"><?=h($u['name'])?></div><div class="list-sub"><?=h($u['email'])?></div></div>
          <div><?= ((int)$u['is_active']===1) ? '<span class="badge bg-success glow-badge">Ativo</span>' : '<span class="badge bg-secondary">Inativo</span>' ?></div>
        </div>
        <div class="list-meta">
          <div class="meta-item"><div class="meta-label">Perfil</div><div class="meta-value"><?=h($u['role'])?></div></div>
          <div class="meta-item"><div class="meta-label">Criado</div><div class="meta-value"><?=h(date('d/m/Y', strtotime($u['created_at'])))?></div></div>
        </div>
        <div class="list-actions">
          <?php if (perm_can('users','edit')): ?>
            <a class="btn btn-sm btn-outline-primary" href="users.php?action=editform&id=<?=$u['id']?>">Editar</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
  <?php if(!$users): ?><div class="col-12"><div class="alert alert-warning mb-0">Nenhum usuário.</div></div><?php endif; ?>
</div>

<?php render_footer(); ?>
