<?php
require __DIR__.'/_init.php';
require_login();
require_role('admin');
require_perm('settings','edit');

$cfg = require __DIR__ . '/../app/config.php';
$base = rtrim((string)($cfg['app']['base_url'] ?? ''), '/');

$err=''; $msg='';

function ensure_upload_dir(): string {
  $dir = __DIR__ . '/uploads';
  if (!is_dir($dir)) mkdir($dir, 0775, true);
  return $dir;
}

function upload_image(string $field, int $maxMB=6): ?string {
  if (empty($_FILES[$field]) || $_FILES[$field]['error'] === UPLOAD_ERR_NO_FILE) return null;
  if ($_FILES[$field]['error'] !== UPLOAD_ERR_OK) throw new Exception('Falha no upload.');
  if ($_FILES[$field]['size'] > $maxMB*1024*1024) throw new Exception('Imagem muito grande.');

  $tmp = $_FILES[$field]['tmp_name'];
  $finfo = new finfo(FILEINFO_MIME_TYPE);
  $mime = $finfo->file($tmp);

  $ext = match($mime) {
    'image/png' => 'png',
    'image/jpeg' => 'jpg',
    'image/webp' => 'webp',
    default => null
  };
  if (!$ext) throw new Exception('Tipo de imagem inválido. Use PNG/JPG/WEBP.');

  $dir = ensure_upload_dir();
  $name = bin2hex(random_bytes(12)).'.'.$ext;
  $dest = $dir.'/'.$name;
  if (!move_uploaded_file($tmp, $dest)) throw new Exception('Não foi possível salvar a imagem.');

  return '/uploads/'.$name;
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  try {
    setting_set('app.name', trim($_POST['app_name'] ?? 'Financeiro'), false);

    $logo = upload_image('logo');
    if ($logo) setting_set('app.logo_path', $logo, false);

    $bg = upload_image('login_bg');
    if ($bg) setting_set('app.login_bg_path', $bg, false);

    // SMTP
    setting_set('smtp.host', trim($_POST['smtp_host'] ?? ''), false);
    setting_set('smtp.port', trim($_POST['smtp_port'] ?? '587'), false);
    setting_set('smtp.secure', trim($_POST['smtp_secure'] ?? 'tls'), false);
    setting_set('smtp.user', trim($_POST['smtp_user'] ?? ''), false);
    if (!empty($_POST['smtp_pass'])) setting_set('smtp.pass', $_POST['smtp_pass'], true);
    setting_set('smtp.from_email', trim($_POST['smtp_from_email'] ?? ''), false);
    setting_set('smtp.from_name', trim($_POST['smtp_from_name'] ?? ''), false);

    // IA
    $prov = $_POST['ai_provider_default'] ?? 'openai';
    if (!in_array($prov, ['openai','gemini'], true)) $prov='openai';
    setting_set('ai.provider_default', $prov, false);

    if (!empty($_POST['openai_key'])) setting_set('openai.api_key', $_POST['openai_key'], true);
    setting_set('openai.model', trim($_POST['openai_model'] ?? 'gpt-5'), false);

    if (!empty($_POST['gemini_key'])) setting_set('gemini.api_key', $_POST['gemini_key'], true);
    setting_set('gemini.model', trim($_POST['gemini_model'] ?? 'gemini-1.5-pro'), false);

    $msg='Configurações salvas.';
  } catch(Throwable $e) { $err=$e->getMessage(); }
}

render_header('Configurações');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

$appName = (string)setting_get('app.name','Financeiro');
?>
<h3 class="mb-3">Configurações</h3>

<form method="post" enctype="multipart/form-data" class="card shadow-sm p-3">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">

  <h5 class="mb-2">Branding</h5>
  <div class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Nome do sistema</label>
      <input class="form-control" name="app_name" value="<?=h($appName)?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">Logo (PNG/JPG/WEBP)</label>
      <input class="form-control" type="file" name="logo" accept="image/png,image/jpeg,image/webp">
    </div>
    <div class="col-md-3">
      <label class="form-label">Fundo do login</label>
      <input class="form-control" type="file" name="login_bg" accept="image/png,image/jpeg,image/webp">
    </div>
  </div>

  <hr class="my-4">

  <h5 class="mb-2">SMTP (e-mail)</h5>
  <div class="row g-3">
    <div class="col-md-4">
      <label class="form-label">Host</label>
      <input class="form-control" name="smtp_host" value="<?=h((string)setting_get('smtp.host',''))?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">Porta</label>
      <input class="form-control" name="smtp_port" value="<?=h((string)setting_get('smtp.port','587'))?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">Secure</label>
      <?php $sec=(string)setting_get('smtp.secure','tls'); ?>
      <select class="form-select" name="smtp_secure">
        <option value="tls" <?=$sec==='tls'?'selected':''?>>tls</option>
        <option value="ssl" <?=$sec==='ssl'?'selected':''?>>ssl</option>
        <option value="" <?=$sec===''?'selected':''?>>(nenhum)</option>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Usuário</label>
      <input class="form-control" name="smtp_user" value="<?=h((string)setting_get('smtp.user',''))?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">Senha (preencha só se for trocar)</label>
      <input class="form-control" name="smtp_pass" type="password" placeholder="••••••••">
    </div>
    <div class="col-md-4">
      <label class="form-label">From e-mail</label>
      <input class="form-control" name="smtp_from_email" value="<?=h((string)setting_get('smtp.from_email',''))?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">From nome</label>
      <input class="form-control" name="smtp_from_name" value="<?=h((string)setting_get('smtp.from_name','Financeiro'))?>">
    </div>
  </div>

  <div class="mt-4">
    <button class="btn btn-primary">Salvar</button>
  </div>
</form>

<?php render_footer(); ?>
