<?php
require __DIR__.'/_init.php';

$token = $_GET['token'] ?? '';
$err=''; $ok='';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $token = $_POST['token'] ?? '';
  $pass1 = $_POST['pass1'] ?? '';
  $pass2 = $_POST['pass2'] ?? '';

  if (strlen($pass1) < 8) $err = 'Senha mínima: 8 caracteres.';
  elseif ($pass1 !== $pass2) $err = 'Senhas não conferem.';
  else {
    $hash = hash('sha256', $token);
    $pdo = db();
    $st = $pdo->prepare("
      SELECT pr.id, pr.user_id
      FROM password_resets pr
      WHERE pr.token_hash=? AND pr.used_at IS NULL AND pr.expires_at > NOW()
      ORDER BY pr.id DESC LIMIT 1
    ");
    $st->execute([$hash]);
    $pr = $st->fetch();

    if (!$pr) $err='Token inválido ou expirado.';
    else {
      $pdo->beginTransaction();
      $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")
          ->execute([password_hash($pass1, PASSWORD_BCRYPT), (int)$pr['user_id']]);
      $pdo->prepare("UPDATE password_resets SET used_at=NOW() WHERE id=?")->execute([(int)$pr['id']]);
      $pdo->commit();
      $ok='Senha atualizada. Você já pode fazer login.';
    }
  }
}

render_header('Redefinir senha');
?>
<h3>Redefinir senha</h3>
<?php if ($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>
<?php if ($ok): ?><div class="alert alert-success"><?=h($ok)?></div><?php endif; ?>

<form method="post" class="card shadow-sm p-3" style="max-width:520px">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <input type="hidden" name="token" value="<?=h($token)?>">
  <label class="form-label">Nova senha</label>
  <input class="form-control" type="password" name="pass1" required>
  <label class="form-label mt-2">Confirmar senha</label>
  <input class="form-control" type="password" name="pass2" required>
  <button class="btn btn-primary mt-3">Salvar</button>
  <a class="btn btn-link mt-2" href="login.php">Voltar</a>
</form>
<?php render_footer(); ?>
