<?php
require __DIR__.'/_init.php';
require_login();
require_perm('reconcile','view');

$pdo=db();
$err=''; $msg='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  try{
    $se=(int)($_POST['statement_id'] ?? 0);
    $led=(int)($_POST['ledger_id'] ?? 0);
    if($se<=0 || $led<=0) throw new Exception('IDs inválidos.');
    $pdo->prepare("INSERT INTO bank_reconciliations (statement_entry_id, ledger_id, matched_by) VALUES (?,?, 'MANUAL')")
        ->execute([$se,$led]);
    $msg='Conciliação salva.';
  }catch(Throwable $e){ $err=$e->getMessage(); }
}

$entries=$pdo->query("
  SELECT se.*
  FROM bank_statement_entries se
  LEFT JOIN bank_reconciliations br ON br.statement_entry_id=se.id
  WHERE br.id IS NULL
  ORDER BY se.posted_date DESC, se.id DESC
  LIMIT 80
")->fetchAll();

$suggest=$pdo->prepare("
  SELECT bl.id, bl.occurred_at, bl.entry_type, bl.amount, bl.description
  FROM bank_ledger bl
  LEFT JOIN bank_reconciliations br ON br.ledger_id = bl.id
  WHERE br.id IS NULL
    AND bl.bank_id = :bank_id
    AND bl.amount = :amount
    AND DATE(bl.occurred_at) BETWEEN DATE_SUB(:posted_date, INTERVAL 3 DAY) AND DATE_ADD(:posted_date, INTERVAL 3 DAY)
  ORDER BY ABS(DATEDIFF(DATE(bl.occurred_at), :posted_date)) ASC
  LIMIT 1
");

render_header('Conciliação - Revisão');
?>
<h3 class="mb-3">Revisão manual</h3>
<?php if($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0 align-middle">
      <thead class="table-dark">
        <tr>
          <th>Data</th><th>Banco</th><th class="text-end">Valor</th><th>Descrição</th><th>Sugestão</th><th style="width:160px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($entries as $e): ?>
          <?php
            $suggest->execute([':bank_id'=>(int)$e['bank_id'], ':amount'=>$e['amount'], ':posted_date'=>$e['posted_date']]);
            $sug=$suggest->fetch();
          ?>
          <tr>
            <td><?=h(date('d/m/Y', strtotime($e['posted_date'])))?></td>
            <td>#<?=h((string)$e['bank_id'])?></td>
            <td class="text-end">R$ <?=h(number_format((float)$e['amount'],2,',','.'))?></td>
            <td><?=h($e['description'])?></td>
            <td>
              <?php if($sug): ?>
                <div class="small"><b>#<?=$sug['id']?></b> <?=h($sug['entry_type'])?> — <?=h(date('d/m H:i', strtotime($sug['occurred_at'])))?></div>
                <div class="text-muted small"><?=h($sug['description'])?></div>
              <?php else: ?>
                <span class="text-muted">Sem sugestão</span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <?php if($sug): ?>
                <form method="post" class="d-inline">
                  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
                  <input type="hidden" name="statement_id" value="<?=$e['id']?>">
                  <input type="hidden" name="ledger_id" value="<?=$sug['id']?>">
                  <button class="btn btn-sm btn-success">Conciliar</button>
                </form>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$entries): ?>
          <tr><td colspan="6" class="text-center text-muted py-4">Nada pendente.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php render_footer(); ?>
