<?php
require __DIR__.'/_init.php';
require_login();
require_perm('reconcile','view');

$pdo=db();
$err=''; $msg='';

try{
  $stmt=$pdo->query("
    SELECT se.*
    FROM bank_statement_entries se
    LEFT JOIN bank_reconciliations br ON br.statement_entry_id=se.id
    WHERE br.id IS NULL
    ORDER BY se.posted_date DESC, se.id DESC
    LIMIT 300
  ");
  $entries=$stmt->fetchAll();

  $matchCount=0;
  $find=$pdo->prepare("
    SELECT bl.id
    FROM bank_ledger bl
    LEFT JOIN bank_reconciliations br ON br.ledger_id = bl.id
    WHERE br.id IS NULL
      AND bl.bank_id = :bank_id
      AND bl.amount = :amount
      AND DATE(bl.occurred_at) BETWEEN DATE_SUB(:posted_date, INTERVAL 3 DAY) AND DATE_ADD(:posted_date, INTERVAL 3 DAY)
    ORDER BY ABS(DATEDIFF(DATE(bl.occurred_at), :posted_date)) ASC
    LIMIT 1
  ");
  $ins=$pdo->prepare("INSERT INTO bank_reconciliations (statement_entry_id, ledger_id, matched_by) VALUES (?,?, 'AUTO')");

  $pdo->beginTransaction();
  foreach($entries as $e){
    $find->execute([
      ':bank_id'=>(int)$e['bank_id'],
      ':amount'=>$e['amount'],
      ':posted_date'=>$e['posted_date'],
    ]);
    $ledId=$find->fetchColumn();
    if($ledId){
      $ins->execute([(int)$e['id'], (int)$ledId]);
      $matchCount++;
    }
  }
  $pdo->commit();

  $msg="Auto-match concluído. Casados: {$matchCount}. Vá em Revisão para ajustar.";
}catch(Throwable $e){
  if($pdo->inTransaction()) $pdo->rollBack();
  $err=$e->getMessage();
}

render_header('Conciliação - Auto-match');
?>
<h3 class="mb-3">Auto-match</h3>
<?php if($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>
<a class="btn btn-secondary" href="reconcile_review.php">Ir para revisão</a>
<?php render_footer(); ?>
