<?php
require __DIR__.'/_init.php';
require_login();
require_perm('reconcile','view');

$pdo=db();
$banks=$pdo->query("SELECT id, bank_name, bank_number FROM banks ORDER BY bank_name")->fetchAll();

$err=''; $msg='';
if($_SERVER['REQUEST_METHOD']==='POST') {
  require_perm('reconcile','create');
{
  csrf_check();
  try{
    $bankId=(int)($_POST['bank_id'] ?? 0);
    if($bankId<=0) throw new Exception('Selecione um banco.');
    if(empty($_FILES['csv']) || $_FILES['csv']['error']!==UPLOAD_ERR_OK) throw new Exception('Envie um CSV válido.');

    $fh=fopen($_FILES['csv']['tmp_name'],'r');
    if(!$fh) throw new Exception('Não foi possível ler o CSV.');

    $first=fgetcsv($fh, 0, ',');
    if(!$first) throw new Exception('CSV vazio.');

    $hasHeader = (stripos(implode(',',$first), 'date') !== false);
    $rows = [];
    if(!$hasHeader) $rows[] = $first;
    while(($r=fgetcsv($fh,0,','))!==false){ $rows[]=$r; }
    fclose($fh);

    $ins=$pdo->prepare("
      INSERT INTO bank_statement_entries (bank_id, posted_date, amount, description, external_id)
      VALUES (?,?,?,?,?)
    ");

    $count=0;
    foreach($rows as $r){
      $date=trim($r[0] ?? '');
      $amount=money_to_decimal($r[1] ?? '0');
      $desc=trim($r[2] ?? '');
      $ext=trim($r[3] ?? '') ?: null;
      if(!$date || !$desc || (float)$amount==0.0) continue;

      if(str_contains($date,'/')){
        [$d,$m,$y]=explode('/',$date);
        $date = sprintf('%04d-%02d-%02d',(int)$y,(int)$m,(int)$d);
      }
      $ins->execute([$bankId, $date, $amount, $desc, $ext]);
      $count++;
    }

    $msg="Importado: {$count} linhas. Agora clique em Auto-match.";
  }catch(Throwable $e){ $err=$e->getMessage(); }
}

render_header('Conciliação - Importar');
?>
<h3 class="mb-3">Conciliação Bancária</h3>
<?php if($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<form method="post" enctype="multipart/form-data" class="card shadow-sm p-3" style="max-width:720px">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <div class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Banco</label>
      <select class="form-select" name="bank_id" required>
        <option value="">Selecione...</option>
        <?php foreach($banks as $b): ?>
          <option value="<?=$b['id']?>"><?=h($b['bank_name'].' ('.$b['bank_number'].')')?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-6">
      <label class="form-label">Arquivo CSV</label>
      <input class="form-control" type="file" name="csv" accept=".csv,text/csv" required>
      <div class="form-text">Formato: date,amount,description,external_id</div>
    </div>
  </div>
  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-primary">Importar</button>
    <a class="btn btn-outline-dark" href="reconcile_match.php">Auto-match</a>
    <a class="btn btn-secondary" href="reconcile_review.php">Revisão</a>
  </div>
</form>
<?php render_footer(); ?>
