<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin','finance');
require_perm('prompt_categories','view');

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if ($action === 'create') { require_perm('prompt_categories','create');
      $name = trim($_POST['name'] ?? '');
      if ($name === '') throw new Exception('Informe o nome.');
      $pdo->prepare("INSERT INTO prompt_categories (name) VALUES (?)")->execute([$name]);
      redirect('/prompt_categories.php?msg=Categoria criada');
    }
    if ($action === 'edit') { require_perm('prompt_categories','edit');
      $id = (int)($_POST['id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $is_active = (int)($_POST['is_active'] ?? 1);
      if ($name === '') throw new Exception('Informe o nome.');
      $pdo->prepare("UPDATE prompt_categories SET name=?, is_active=?, updated_at=NOW() WHERE id=?")->execute([$name,$is_active,$id]);
      redirect('/prompt_categories.php?msg=Categoria atualizada');
    }
  } catch (Throwable $e) { $err = $e->getMessage(); }
}

render_header('Categorias de Prompt');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if ($action === 'new') { ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Nova categoria</h3>
    <a class="btn btn-secondary" href="prompt_categories.php">Voltar</a>
  </div>
  <form method="post" action="prompt_categories.php?action=create" class="card shadow-sm p-3" style="max-width:720px">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <label class="form-label">Nome</label>
    <input class="form-control" name="name" required>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="prompt_categories.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

if ($action === 'editform') {
  $id=(int)($_GET['id'] ?? 0);
  $st=$pdo->prepare("SELECT * FROM prompt_categories WHERE id=?");
  $st->execute([$id]);
  $c=$st->fetch();
  if(!$c){ echo '<div class="alert alert-danger">Não encontrada.</div>'; render_footer(); exit; }
?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Editar categoria</h3>
    <a class="btn btn-secondary" href="prompt_categories.php">Voltar</a>
  </div>
  <form method="post" action="prompt_categories.php?action=edit" class="card shadow-sm p-3" style="max-width:820px">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$c['id'])?>">
    <div class="row g-3">
      <div class="col-md-8">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?=h($c['name'])?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Ativa?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=(int)$c['is_active']===1?'selected':''?>>Sim</option>
          <option value="0" <?=(int)$c['is_active']===0?'selected':''?>>Não</option>
        </select>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="prompt_categories.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

$cats=$pdo->query("SELECT * FROM prompt_categories ORDER BY name")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Categorias de Prompt</h3>
  <a class="btn btn-primary" href="prompt_categories.php?action=new">+ Nova</a>
</div>

<div class="row g-3">
  <?php foreach($cats as $c): ?>
    <div class="col-md-4">
      <div class="list-card" data-tilt>
        <div class="d-flex justify-content-between align-items-start">
          <div>
            <div class="list-title"><?=h($c['name'])?></div>
            <div class="list-sub">Categoria</div>
          </div>
          <div><?= ((int)$c['is_active']===1) ? '<span class="badge bg-success glow-badge">Ativa</span>' : '<span class="badge bg-secondary">Inativa</span>' ?></div>
        </div>
        <div class="list-actions">
          <a class="btn btn-sm btn-outline-primary" href="prompt_categories.php?action=editform&id=<?=$c['id']?>">Editar</a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
  <?php if(!$cats): ?><div class="col-12"><div class="alert alert-warning mb-0">Nenhuma categoria.</div></div><?php endif; ?>
</div>

<?php render_footer(); ?>
