<?php
require __DIR__.'/_init.php';
require_login();
require_perm('parties','view');

use Dompdf\Dompdf;

$pdo = db();
$id = (int)($_GET['id'] ?? 0);
$rangeDays = (int)($_GET['range'] ?? 30);
if (!in_array($rangeDays, [5,30,60,90], true)) $rangeDays = 30;
$rangeStart = (new DateTime('now'))->modify('-'.$rangeDays.' days')->format('Y-m-d 00:00:00');
$rangeEnd = (new DateTime('now'))->format('Y-m-d 23:59:59');

$st = $pdo->prepare("SELECT * FROM fin_parties WHERE id=?");
$st->execute([$id]);
$p = $st->fetch();
if (!$p) { http_response_code(404); die('Cadastro não encontrado.'); }

// stats
$stx = $pdo->prepare("
  SELECT
    COALESCE(SUM(d.doc_type='PAGAR'),0) AS docs_pagar,
    COALESCE(SUM(d.doc_type='RECEBER'),0) AS docs_receber,
    COALESCE(SUM(i.status IN ('ABERTO','PARCIAL') AND d.doc_type='PAGAR'),0) AS inst_open_pagar,
    COALESCE(SUM(i.status IN ('ABERTO','PARCIAL') AND d.doc_type='RECEBER'),0) AS inst_open_receber,
    COALESCE(SUM(CASE WHEN d.doc_type='PAGAR' AND i.status IN ('ABERTO','PARCIAL') THEN (i.amount - i.paid_amount) ELSE 0 END),0) AS aberto_pagar,
    COALESCE(SUM(CASE WHEN d.doc_type='RECEBER' AND i.status IN ('ABERTO','PARCIAL') THEN (i.amount - i.paid_amount) ELSE 0 END),0) AS aberto_receber
  FROM fin_documents d
  LEFT JOIN fin_installments i ON i.document_id=d.id
  WHERE d.counterparty_id=?
");
$stx->execute([$id]);
$stats = $stx->fetch() ?: [
  'docs_pagar'=>0,'docs_receber'=>0,'inst_open_pagar'=>0,'inst_open_receber'=>0,'aberto_pagar'=>0,'aberto_receber'=>0
];

function fmt_money(float $v): string { return 'R$ '.number_format($v, 2, ',', '.'); }

// last movements (settlements) for this party
$mov = $pdo->prepare("
  SELECT
    s.occurred_at,
    d.doc_type,
    d.description,
    d.counterparty_name,
    i.installment_no,
    s.amount,
    s.direction,
    b.bank_name,
    b.bank_number,
    s.note
  FROM fin_settlements s
  JOIN fin_installments i ON i.id = s.installment_id
  JOIN fin_documents d ON d.id = i.document_id
  JOIN banks b ON b.id = s.bank_id
  WHERE d.counterparty_id = ? AND s.reversed_at IS NULL
    AND s.occurred_at BETWEEN ? AND ?
  ORDER BY s.occurred_at DESC
  LIMIT 50
");
$mov->execute([$id, $rangeStart, $rangeEnd]);
$movs = $mov->fetchAll();

$appName = (string)setting_get('app.name','Financeiro');
$logoPath = (string)setting_get('app.logo_path','');
$logoDataUri = '';
if ($logoPath) {
  $abs = __DIR__ . $logoPath; // /public + /uploads
  if (file_exists($abs)) {
    $mime = mime_content_type($abs);
    $b64 = base64_encode(file_get_contents($abs));
    $logoDataUri = "data:{$mime};base64,{$b64}";
  }
}

$name = htmlspecialchars((string)$p['name'], ENT_QUOTES, 'UTF-8');
$type = htmlspecialchars((string)$p['party_type'], ENT_QUOTES, 'UTF-8');
$doc  = htmlspecialchars((string)($p['doc'] ?? ''), ENT_QUOTES, 'UTF-8');

$addr = trim(
  (string)($p['address'] ?? '').' '.
  (string)($p['address_number'] ?? '').' '.
  (string)($p['district'] ?? '').' '.
  (string)($p['city'] ?? '').' '.
  (string)($p['state'] ?? '').' '.
  (string)($p['zip_code'] ?? '')
);

$email = htmlspecialchars((string)($p['email'] ?? ''), ENT_QUOTES, 'UTF-8');
$phone = htmlspecialchars((string)($p['phone'] ?? ''), ENT_QUOTES, 'UTF-8');
$notes = htmlspecialchars((string)($p['notes'] ?? ''), ENT_QUOTES, 'UTF-8');

$html = '<html><head><meta charset="utf-8">
<style>
body{font-family: DejaVu Sans, sans-serif; font-size:12px; color:#111;}
h1{font-size:18px;margin:0 0 4px 0;}
h2{font-size:13px;margin:14px 0 6px 0;}
.small{color:#666}
.box{border:1px solid #ddd;border-radius:10px;padding:10px;margin:10px 0;}
.row{display:flex;gap:12px;}
.col{flex:1;}
.badge{display:inline-block;padding:4px 8px;border-radius:6px;background:#111;color:#fff;font-size:11px;}
table{width:100%;border-collapse:collapse;}
th,td{border-bottom:1px solid #eee;padding:8px;text-align:left;vertical-align:top;}
th{background:#f7f7f7;}
</style></head><body>';

$html .= '<div class="row" style="align-items:center;">';
if($logoDataUri) $html .= '<div style="width:64px;"><img src="'.$logoDataUri.'" style="height:44px;"></div>';
$html .= '<div class="col"><h1>'.$appName.' — Ficha de Cadastro</h1><div class="small">Gerado em '.date('d/m/Y H:i').'</div></div>';
$html .= '</div>';

$html .= '<div class="box">';
$html .= '<div class="row"><div class="col"><b>'.$name.'</b><div class="small">'.$type.($doc?(' • '.$doc):'').'</div></div>';
$html .= '<div><span class="badge">'.(((int)$p['is_active']===1)?'ATIVO':'INATIVO').'</span></div></div>';
$html .= '<div style="margin-top:8px" class="small">Contato: '.($email?:'—').' • '.($phone?:'—').'</div>';
$html .= '<div style="margin-top:4px" class="small">Endereço: '.(trim($addr)?htmlspecialchars($addr,ENT_QUOTES,'UTF-8'):'—').'</div>';
if($notes) $html .= '<div style="margin-top:8px">'.$notes.'</div>';
$html .= '</div>';

$html .= '<div class="box">';
$html .= '<h2>Indicadores</h2>';
$html .= '<div class="row">';
$html .= '<div class="col"><div class="small">Docs pagar</div><b>'.(int)$stats['docs_pagar'].'</b></div>';
$html .= '<div class="col"><div class="small">Docs receber</div><b>'.(int)$stats['docs_receber'].'</b></div>';
$html .= '<div class="col"><div class="small">Aberto pagar</div><b>'.fmt_money((float)$stats['aberto_pagar']).'</b></div>';
$html .= '<div class="col"><div class="small">Aberto receber</div><b>'.fmt_money((float)$stats['aberto_receber']).'</b></div>';
$html .= '</div>';
$html .= '<div class="row" style="margin-top:8px">';
$html .= '<div class="col"><div class="small">Parcelas abertas (pagar)</div><b>'.(int)$stats['inst_open_pagar'].'</b></div>';
$html .= '<div class="col"><div class="small">Parcelas abertas (receber)</div><b>'.(int)$stats['inst_open_receber'].'</b></div>';
$html .= '</div>';
$html .= '</div>';

$html .= '<div class="box">';
$html .= '<h2>Movimentações (últimos {$rangeDays} dias — até 50)</h2>';
if(!$movs){
  $html .= '<div class="small">Sem movimentações registradas.</div>';
} else {
  $html .= '<table><thead><tr><th>Data</th><th>Tipo</th><th>Descrição</th><th>Banco</th><th>Valor</th></tr></thead><tbody>';
  foreach($movs as $m){
    $dt = date('d/m/Y H:i', strtotime($m['occurred_at']));
    $tp = htmlspecialchars($m['doc_type'], ENT_QUOTES, 'UTF-8');
    $desc = htmlspecialchars($m['description'], ENT_QUOTES, 'UTF-8');
    $bank = htmlspecialchars($m['bank_name'].' ('.$m['bank_number'].')', ENT_QUOTES, 'UTF-8');
    $val = fmt_money((float)$m['amount']);
    $html .= "<tr><td>{$dt}</td><td>{$tp}</td><td>{$desc}</td><td>{$bank}</td><td>{$val}</td></tr>";
  }
  $html .= '</tbody></table>';
}
$html .= '</div>';

$html .= '</body></html>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

header("Content-Type: application/pdf");
header('Content-Disposition: inline; filename="cadastro_'.$id.'.pdf"');
echo $dompdf->output();
