<?php
require __DIR__.'/_init.php';
require_login();
require_perm('parties','view');

$pdo = db();
$id = (int)($_GET['id'] ?? 0);
$rangeDays = (int)($_GET['range'] ?? 30);
if (!in_array($rangeDays, [5,30,60,90], true)) $rangeDays = 30;
$rangeStart = (new DateTime('now'))->modify('-'.$rangeDays.' days')->format('Y-m-d 00:00:00');
$rangeEnd = (new DateTime('now'))->format('Y-m-d 23:59:59');

$st = $pdo->prepare("SELECT id, name FROM fin_parties WHERE id=?");
$st->execute([$id]);
$p = $st->fetch();
if(!$p){ http_response_code(404); die('Cadastro não encontrado.'); }

$mov = $pdo->prepare("
  SELECT
    s.occurred_at,
    d.doc_type,
    d.description,
    i.installment_no,
    s.amount,
    s.direction,
    b.bank_name,
    b.bank_number,
    COALESCE(s.note,'') AS note
  FROM fin_settlements s
  JOIN fin_installments i ON i.id = s.installment_id
  JOIN fin_documents d ON d.id = i.document_id
  JOIN banks b ON b.id = s.bank_id
  WHERE d.counterparty_id = ? AND s.reversed_at IS NULL
    AND s.occurred_at BETWEEN ? AND ?
  ORDER BY s.occurred_at DESC
");
$mov->execute([$id, $rangeStart, $rangeEnd]);
$rows = $mov->fetchAll();

$filename = 'movimentos_'.$id.'_'.date('Ymd_His').'.csv';
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="'.$filename.'"');

$out = fopen('php://output', 'w');
fputcsv($out, ['occurred_at','doc_type','description','installment_no','amount','direction','bank_name','bank_number','note'], ';');

foreach($rows as $r){
  fputcsv($out, [
    $r['occurred_at'],
    $r['doc_type'],
    $r['description'],
    $r['installment_no'],
    number_format((float)$r['amount'],2,'.',''),
    $r['direction'],
    $r['bank_name'],
    $r['bank_number'],
    $r['note'],
  ], ';');
}
fclose($out);
