<?php
require __DIR__.'/_init.php';

if (!empty($_SESSION['user_id'])) redirect('/index.php');

$base = base_url_runtime();
$bg = (string)setting_get('app.login_bg_path', '');
$logo = (string)setting_get('app.logo_path', '');
$appName = (string)setting_get('app.name', 'Financeiro');

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = trim($_POST['email'] ?? '');
  $pass  = $_POST['password'] ?? '';
  if (login_attempt($email, $pass)) redirect('/index.php');
  $error = 'Login inválido.';
}
?>
<!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="<?=$base?>/assets/app.css" rel="stylesheet">
<title>Login</title>
</head>
<body>
<div class="login-bg" style="<?= $bg ? 'background-image:url('.h($base.$bg).')' : 'background:linear-gradient(135deg,#0f172a,#111827)' ?>">
  <div class="glass">
    <div class="text-center mb-3">
      <?php if ($logo): ?>
        <img src="<?=h($base.$logo)?>" alt="logo" style="max-height:64px;margin:0 auto 10px;">
      <?php endif; ?>
      <div class="h4 text-white mb-0"><?=h($appName)?></div>
      <div class="text-white-50">Acesso ao painel financeiro</div>
    </div>

    <?php if ($error): ?><div class="alert alert-danger"><?=$error?></div><?php endif; ?>

    <form method="post">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <div class="mb-2">
        <label class="form-label text-white">Email</label>
        <input class="form-control" name="email" type="email" required>
      </div>
      <div class="mb-2">
        <label class="form-label text-white">Senha</label>
        <input class="form-control" name="password" type="password" required>
      </div>
      <button class="btn btn-primary w-100 mt-2">Entrar</button>
      <div class="d-flex justify-content-between mt-3">
        <a class="text-white-50" href="<?=$base?>/forgot_password.php">Esqueci a senha</a>
      </div>
    </form>
  </div>
</div>
<script src="<?=$base?>/assets/app.js"></script>
</body></html>
