<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin');
require_perm('ia_settings','edit');

$err=''; $msg='';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  try {
    $prov = $_POST['ai_provider_default'] ?? 'openai';
    if (!in_array($prov, ['openai','gemini'], true)) $prov='openai';
    setting_set('ai.provider_default', $prov, false);

    if (!empty($_POST['openai_key'])) setting_set('openai.api_key', $_POST['openai_key'], true);
    setting_set('openai.model', trim($_POST['openai_model'] ?? 'gpt-5'), false);

    if (!empty($_POST['gemini_key'])) setting_set('gemini.api_key', $_POST['gemini_key'], true);
    setting_set('gemini.model', trim($_POST['gemini_model'] ?? 'gemini-1.5-pro'), false);

    $msg='Configurações de IA salvas.';
  } catch(Throwable $e) { $err=$e->getMessage(); }
}

render_header('Config IA (APIs)');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

$p=(string)setting_get('ai.provider_default','openai');
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Configuração de IA</h3>
  <a class="btn btn-secondary" href="assistant_ai.php">Voltar</a>
</div>

<form method="post" class="card shadow-sm p-3">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <div class="row g-3">
    <div class="col-md-4">
      <label class="form-label">Provider padrão</label>
      <select class="form-select" name="ai_provider_default">
        <option value="openai" <?=$p==='openai'?'selected':''?>>OpenAI</option>
        <option value="gemini" <?=$p==='gemini'?'selected':''?>>Gemini</option>
      </select>
    </div>
  </div>

  <hr class="my-3">
  <h5 class="mb-2">OpenAI</h5>
  <div class="row g-3 mb-3">
    <div class="col-md-4">
      <label class="form-label">Model</label>
      <input class="form-control" name="openai_model" value="<?=h((string)setting_get('openai.model','gpt-5'))?>">
    </div>
    <div class="col-md-8">
      <label class="form-label">API Key (trocar)</label>
      <input class="form-control" name="openai_key" type="password" placeholder="sk-...">
    </div>
  </div>

  <h5 class="mb-2">Gemini</h5>
  <div class="row g-3">
    <div class="col-md-4">
      <label class="form-label">Model</label>
      <input class="form-control" name="gemini_model" value="<?=h((string)setting_get('gemini.model','gemini-1.5-pro'))?>">
    </div>
    <div class="col-md-8">
      <label class="form-label">API Key (trocar)</label>
      <input class="form-control" name="gemini_key" type="password" placeholder="...">
    </div>
  </div>

  <div class="mt-4">
    <button class="btn btn-primary">Salvar</button>
  </div>
</form>

<?php render_footer(); ?>
