<?php
require __DIR__.'/_init.php';
require __DIR__.'/../app/mailer.php';

$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  $email = trim($_POST['email'] ?? '');

  // Sempre responde OK (anti enumeração)
  $msg = 'Se existir uma conta com esse e-mail, você receberá um link de redefinição.';

  if ($email) {
    $pdo = db();
    $st = $pdo->prepare("SELECT id, name, email FROM users WHERE email=? AND is_active=1 LIMIT 1");
    $st->execute([$email]);
    $u = $st->fetch();

    if ($u) {
      $token = bin2hex(random_bytes(32));
      $hash = hash('sha256', $token);
      $exp = (new DateTime('+30 minutes'))->format('Y-m-d H:i:s');

      $pdo->prepare("INSERT INTO password_resets (user_id, token_hash, expires_at) VALUES (?,?,?)")
          ->execute([(int)$u['id'], $hash, $exp]);

      $base = base_url_runtime();
      $link = $base . "/reset_password.php?token=" . $token;
      $appName = (string)setting_get('app.name','Financeiro');

      $html = "<p>Olá, ".h($u['name']).".</p>
               <p>Clique para redefinir sua senha (válido por 30 minutos):</p>
               <p><a href='".h($link)."'>Redefinir senha</a></p>";

      try { mailer_send($u['email'], $u['name'], "$appName - Redefinição de senha", $html); } catch(Throwable $e) {}
    }
  }
}

render_header('Esqueci a senha');
?>
<h3>Esqueci a senha</h3>
<?php if ($msg): ?><div class="alert alert-info"><?=h($msg)?></div><?php endif; ?>
<form method="post" class="card shadow-sm p-3" style="max-width:520px">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <label class="form-label">Seu e-mail</label>
  <input class="form-control" name="email" type="email" required>
  <button class="btn btn-primary mt-3">Enviar link</button>
  <a class="btn btn-link mt-2" href="login.php">Voltar</a>
</form>
<?php render_footer(); ?>
