<?php
require __DIR__.'/_init.php';
require_login();

$pdo=db();
$id=(int)($_GET['id'] ?? 0);

$st=$pdo->prepare("
  SELECT s.*, i.id AS inst_id, d.doc_type, d.counterparty_name, d.description
  FROM fin_settlements s
  JOIN fin_installments i ON i.id=s.installment_id
  JOIN fin_documents d ON d.id=i.document_id
  WHERE s.id=?
");
$st->execute([$id]);
$s=$st->fetch();
if(!$s){ render_header('Erro'); echo '<div class="alert alert-danger">Baixa não encontrada.</div>'; render_footer(); exit; }
$permKey = ($s['doc_type']==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'delete');

$err='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  csrf_check();
  try{
    $note=trim($_POST['note'] ?? '');
    settlement_reverse((int)$s['id'], $note);
    redirect('/baixas.php?installment_id='.$s['inst_id']);
  }catch(Throwable $e){ $err=$e->getMessage(); }
}

render_header('Estornar baixa');
?>
<h3 class="mb-3">Estornar baixa</h3>
<?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<div class="card shadow-sm p-3 mb-3">
  <div><b><?=h($s['doc_type'])?></b> — <?=h($s['counterparty_name'])?> — <?=h($s['description'])?></div>
  <div class="text-muted">Valor: R$ <?=h(number_format((float)$s['amount'],2,',','.'))?></div>
</div>

<form method="post" class="card shadow-sm p-3" onsubmit="return confirm('Confirmar estorno? Isso reverte saldo do banco.');">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <label class="form-label">Motivo (opcional)</label>
  <input class="form-control" name="note" placeholder="Baixa lançada errada...">
  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-danger">Estornar</button>
    <a class="btn btn-secondary" href="baixas.php?installment_id=<?=$s['inst_id']?>">Cancelar</a>
  </div>
</form>
<?php render_footer(); ?>
