<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin','finance','read');
require_perm('dre','view');

$pdo=db();
$start = $_GET['start'] ?? date('Y-m-01');
$end   = $_GET['end'] ?? date('Y-m-t');

$startDT = $start.' 00:00:00';
$endDT = $end.' 23:59:59';

$rows = $pdo->prepare("
  SELECT COALESCE(a.code,'(sem)') AS code, COALESCE(a.name,'(sem conta)') AS name, COALESCE(a.type,'') AS type,
    SUM(CASE WHEN bl.entry_type='CREDITO' THEN bl.amount ELSE 0 END) AS entradas,
    SUM(CASE WHEN bl.entry_type='DEBITO' THEN bl.amount ELSE 0 END) AS saidas
  FROM bank_ledger bl
  LEFT JOIN fin_settlements s ON s.id=bl.settlement_id
  LEFT JOIN fin_installments i ON i.id=s.installment_id
  LEFT JOIN fin_documents d ON d.id=i.document_id
  LEFT JOIN fin_accounts a ON a.id=d.account_id
  WHERE bl.occurred_at BETWEEN ? AND ?
  GROUP BY code, name, type
  ORDER BY type, code
");
$rows->execute([$startDT,$endDT]);
$data=$rows->fetchAll();

$totReceita=0.0; $totDesp=0.0;
foreach($data as $r){
  if(($r['type'] ?? '')==='RECEITA') $totReceita += ((float)$r['entradas'] - (float)$r['saidas']);
  if(($r['type'] ?? '')==='DESPESA') $totDesp += ((float)$r['saidas'] - (float)$r['entradas']);
}

$lucro = $totReceita - $totDesp;

render_header('DRE');
?>
<h3 class="mb-3">DRE (Realizado)</h3>

<form class="card shadow-sm p-3 mb-3">
  <div class="row g-3 align-items-end">
    <div class="col-md-3">
      <label class="form-label">Início</label>
      <input class="form-control" type="date" name="start" value="<?=h($start)?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">Fim</label>
      <input class="form-control" type="date" name="end" value="<?=h($end)?>">
    </div>
    <div class="col-md-2 d-grid">
      <button class="btn btn-outline-dark">Gerar</button>
    </div>
  </div>
</form>

<div class="row g-3 mb-3">
  <div class="col-md-4"><div class="card shadow-sm"><div class="card-body">
    <div class="text-muted">Receitas (líquido)</div>
    <div class="fs-4 fw-bold">R$ <?=h(number_format($totReceita,2,',','.'))?></div>
  </div></div></div>
  <div class="col-md-4"><div class="card shadow-sm"><div class="card-body">
    <div class="text-muted">Despesas (líquido)</div>
    <div class="fs-4 fw-bold">R$ <?=h(number_format($totDesp,2,',','.'))?></div>
  </div></div></div>
  <div class="col-md-4"><div class="card shadow-sm"><div class="card-body">
    <div class="text-muted">Resultado</div>
    <div class="fs-4 fw-bold">R$ <?=h(number_format($lucro,2,',','.'))?></div>
  </div></div></div>
</div>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead class="table-dark">
        <tr><th>Tipo</th><th>Código</th><th>Conta</th><th class="text-end">Entradas</th><th class="text-end">Saídas</th><th class="text-end">Líquido</th></tr>
      </thead>
      <tbody>
        <?php foreach($data as $r): ?>
          <?php $liq = (float)$r['entradas'] - (float)$r['saidas']; ?>
          <tr>
            <td><?=h($r['type'] ?: '—')?></td>
            <td><?=h($r['code'])?></td>
            <td><?=h($r['name'])?></td>
            <td class="text-end">R$ <?=h(number_format((float)$r['entradas'],2,',','.'))?></td>
            <td class="text-end">R$ <?=h(number_format((float)$r['saidas'],2,',','.'))?></td>
            <td class="text-end">R$ <?=h(number_format($liq,2,',','.'))?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$data): ?><tr><td colspan="6" class="text-center text-muted py-4">Sem dados no período.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php render_footer(); ?>
