<?php
require __DIR__ . '/_init.php';
require_login();
require_perm('cost_centers','view');

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if ($action === 'create') { require_perm('cost_centers','create');
      $name = trim($_POST['name'] ?? '');
      if ($name === '') throw new Exception('Informe o nome.');
      $pdo->prepare("INSERT INTO fin_cost_centers (name) VALUES (?)")->execute([$name]);
      audit_log('create','cost_center',$pdo->lastInsertId(),['name'=>$name]);
      redirect('/cost_centers.php?msg=Centro de custo criado');
    }

    if ($action === 'edit') { require_perm('cost_centers','edit');
      $id = (int)($_POST['id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $is_active = (int)($_POST['is_active'] ?? 1);
      if ($name === '') throw new Exception('Informe o nome.');

      $pdo->prepare("
        UPDATE fin_cost_centers
        SET name=?, is_active=?, updated_at=NOW()
        WHERE id=?
      ")->execute([$name, $is_active, $id]);

      audit_log('edit','cost_center',$id,[]);
      redirect('/cost_centers.php?msg=Centro de custo atualizado');
    }
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

render_header('Centros de Custo');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if ($action === 'new') { ?>
  <h3>Novo Centro de Custo</h3>
  <form method="post" action="cost_centers.php?action=create" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row g-3">
      <div class="col-md-8">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" required>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="cost_centers.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

if ($action === 'editform') {
  $id = (int)($_GET['id'] ?? 0);
  $st = $pdo->prepare("SELECT * FROM fin_cost_centers WHERE id=?");
  $st->execute([$id]);
  $cc = $st->fetch();
  if (!$cc) { echo '<div class="alert alert-danger">Centro não encontrado.</div>'; render_footer(); exit; }
  ?>
  <h3>Editar Centro de Custo</h3>
  <form method="post" action="cost_centers.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$cc['id'])?>">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?=h($cc['name'])?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Ativo?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=$cc['is_active']?'selected':''?>>Sim</option>
          <option value="0" <?=!$cc['is_active']?'selected':''?>>Não</option>
        </select>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="cost_centers.php">Voltar</a>
    </div>
  </form>
<?php render_footer(); exit; }

$ccs = $pdo->query("SELECT * FROM fin_cost_centers ORDER BY name")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Centros de Custo</h3>
  
  <div class="listview-toggle">
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="grid" title="Grade"><i class="bi bi-grid-3x3-gap"></i></button>
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="compact" title="Compacto"><i class="bi bi-list"></i></button>
  </div>
<?php if (perm_can('cost_centers','create')): ?>
<a class="btn btn-primary" href="cost_centers.php?action=new">+ Novo Centro</a>
<?php endif; ?>
</div>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead class="table-dark">
        <tr>
          <th>Nome</th><th>Status</th><th style="width:140px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($ccs as $cc): ?>
          <tr>
            <td><?=h($cc['name'])?></td>
            <td><?= $cc['is_active'] ? '<span class="badge bg-success glow-badge">Ativo</span>' : '<span class="badge bg-secondary">Inativo</span>' ?></td>
            <td class="text-end">
              <?php if (perm_can('cost_centers','edit')): ?>
<a class="btn btn-sm btn-outline-primary" href="cost_centers.php?action=editform&id=<?=$cc['id']?>">Editar</a>
<?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$ccs): ?>
          <tr><td colspan="3" class="text-center text-muted py-4">Nenhum centro de custo.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php render_footer(); ?>
