<?php
require __DIR__ . '/_init.php';
require_login();

$pdo = db();
$type = $_GET['type'] ?? 'PAGAR';
if (!in_array($type, ['PAGAR','RECEBER'], true)) $type = 'PAGAR';
$permKey = ($type==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'view');

$status = $_GET['status'] ?? 'ABERTO'; // ABERTO | PARCIAL | BAIXADO | CANCELADO | TODOS
$search = trim($_GET['q'] ?? '');

$where = "d.doc_type = :type";
$params = [':type' => $type];

if ($status !== 'TODOS') {
  $where .= " AND i.status = :st";
  $params[':st'] = $status;
}

if ($search !== '') {
  $where .= " AND (d.counterparty_name LIKE :q OR d.description LIKE :q OR COALESCE(d.doc_number,'') LIKE :q)";
  $params[':q'] = "%{$search}%";
}

$sql = "
  SELECT
    i.id, i.installment_no, i.due_date, i.amount, i.paid_amount, i.status,
    COALESCE(p.name, d.counterparty_name) AS counterparty_name, d.description, d.doc_number,
    c.name AS category_name,
    cc.name AS cost_center_name,
    b.bank_name, b.bank_number
  FROM fin_installments i
  JOIN fin_documents d ON d.id = i.document_id
  JOIN banks b ON b.id = i.bank_id
  LEFT JOIN fin_categories c ON c.id = d.category_id
  LEFT JOIN fin_cost_centers cc ON cc.id = d.cost_center_id
  LEFT JOIN fin_parties p ON p.id = d.counterparty_id
  WHERE {$where}
  ORDER BY i.due_date ASC, i.id ASC
";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

render_header($type === 'PAGAR' ? 'Contas a Pagar' : 'Contas a Receber');
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3><?=$type==='PAGAR'?'Contas a Pagar':'Contas a Receber'?></h3>
  <?php if (perm_can($permKey,'create')): ?>
<a class="btn btn-primary" href="conta_form.php?type=<?=$type?>">+ Novo lançamento</a>
<?php endif; ?>
</div>

<form class="row g-2 mb-3">
  <input type="hidden" name="type" value="<?=h($type)?>">
  <div class="col-md-3">
    <select class="form-select" name="status">
      <?php $opts=['ABERTO'=>'Abertas','PARCIAL'=>'Parciais','BAIXADO'=>'Baixadas','CANCELADO'=>'Canceladas','TODOS'=>'Todas']; ?>
      <?php foreach($opts as $k=>$v): ?>
        <option value="<?=$k?>" <?=$status===$k?'selected':''?>><?=$v?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-6">
    <input class="form-control" name="q" value="<?=h($search)?>" placeholder="Buscar por pessoa, descrição ou nº doc">
  </div>
  <div class="col-md-3 d-grid">
    <button class="btn btn-outline-dark">Filtrar</button>
  </div>
</form>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0 align-middle">
      <thead class="table-dark">
        <tr>
          <th>Venc.</th>
          <th>Cliente/Fornecedor</th>
          <th>Descrição</th>
          <th>Cat/CC</th>
          <th>Banco</th>
          <th>Parc.</th>
          <th class="text-end">Valor</th>
          <th class="text-end">Pago</th>
          <th>Status</th>
          <th style="width:360px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <?php $rest = (float)$r['amount'] - (float)$r['paid_amount']; ?>
          <tr>
            <td><?=h(date('d/m/Y', strtotime($r['due_date'])))?></td>
            <td><?=h($r['counterparty_name'])?></td>
            <td>
              <?=h($r['description'])?>
              <?php if (!empty($r['doc_number'])): ?>
                <div class="text-muted small">Nº: <?=h($r['doc_number'])?></div>
              <?php endif; ?>
              <?php if ($rest>0.00001 && (float)$r['paid_amount']>0.00001): ?>
                <div class="text-muted small">Restante: R$ <?=h(number_format($rest,2,',','.'))?></div>
              <?php endif; ?>
            </td>
            <td>
              <div class="small"><?=h($r['category_name'] ?? '—')?></div>
              <div class="text-muted small"><?=h($r['cost_center_name'] ?? '—')?></div>
            </td>
            <td><?=h($r['bank_name'])?> (<?=h($r['bank_number'])?>)</td>
            <td><?=h((string)$r['installment_no'])?></td>
            <td class="text-end">R$ <?=h(number_format((float)$r['amount'],2,',','.'))?></td>
            <td class="text-end">R$ <?=h(number_format((float)$r['paid_amount'],2,',','.'))?></td>
            <td>
              <?php
                $st=$r['status'];
                if ($st==='ABERTO') echo '<span class="badge bg-warning text-dark">ABERTO</span>';
                elseif ($st==='PARCIAL') echo '<span class="badge bg-info text-dark">PARCIAL</span>';
                elseif ($st==='BAIXADO') echo '<span class="badge bg-success">BAIXADO</span>';
                else echo '<span class="badge bg-secondary">CANCELADO</span>';
              ?>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-primary" href="parcela_edit.php?id=<?=$r['id']?>">Editar</a>

              <?php if (in_array($r['status'], ['ABERTO','PARCIAL'], true)): ?>
                <a class="btn btn-sm btn-outline-success" href="baixar.php?id=<?=$r['id']?>">Dar baixa</a>
              <?php endif; ?>

              <?php if (in_array($r['status'], ['PARCIAL','BAIXADO'], true)): ?>
                <a class="btn btn-sm btn-outline-dark" href="baixas.php?installment_id=<?=$r['id']?>">Baixas</a>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$rows): ?>
          <tr><td colspan="10" class="text-center text-muted py-4">Nenhum registro.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php render_footer(); ?>
