<?php
require __DIR__ . '/_init.php';
require_login();

$pdo = db();

$type = $_GET['type'] ?? 'PAGAR';
if (!in_array($type, ['PAGAR','RECEBER'], true)) $type = 'PAGAR';

$permKey = ($type==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'create');

// Mostrar clientes no PAGAR (opcional)
$showClients = (int)($_GET['show_clients'] ?? 0);
if ($showClients === 0 && isset($_COOKIE['show_clients_pagar'])) {
  $showClients = (int)($_COOKIE['show_clients_pagar'] ?? 0);
}
if ($type !== 'PAGAR') $showClients = 0;

$prefPartyId = (int)($_GET['party_id'] ?? 0);

$banks = $pdo->query("SELECT id, bank_name, bank_number, agency, account_number, account_type FROM banks ORDER BY bank_name")->fetchAll();
$cats = $pdo->query("SELECT id, name, type FROM fin_categories WHERE is_active=1 ORDER BY name")->fetchAll();
$ccs = $pdo->query("SELECT id, name FROM fin_cost_centers WHERE is_active=1 ORDER BY name")->fetchAll();
$accounts = $pdo->query("SELECT id, code, name, type FROM fin_accounts WHERE is_active=1 ORDER BY code")->fetchAll();

$partyWhere = ($type==='PAGAR')
  ? ($showClients ? "(party_type IN ('FORNECEDOR','AMBOS','CLIENTE'))" : "(party_type='FORNECEDOR' OR party_type='AMBOS')")
  : "(party_type='CLIENTE' OR party_type='AMBOS')";

$parties = $pdo->query("SELECT id, name, party_type FROM fin_parties WHERE is_active=1 AND {$partyWhere} ORDER BY name")->fetchAll();

// garante que party_id preselecionado apareça mesmo se não estiver no filtro
if ($prefPartyId>0) {
  $found = false;
  foreach ($parties as $ppp) { if ((int)$ppp['id'] === $prefPartyId) { $found = true; break; } }
  if (!$found) {
    $stPref = $pdo->prepare("SELECT id, name, party_type FROM fin_parties WHERE id=? AND is_active=1 LIMIT 1");
    $stPref->execute([$prefPartyId]);
    $prefRow = $stPref->fetch();
    if ($prefRow) array_unshift($parties, $prefRow);
  }
}

$msg = $_GET['msg'] ?? '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    $doc_type = $_POST['doc_type'] ?? $type;

    $counterparty_id = (int)($_POST['counterparty_id'] ?? 0);
    if ($counterparty_id <= 0) throw new Exception('Selecione um cliente/fornecedor.');

    $stp = $pdo->prepare("SELECT id, name FROM fin_parties WHERE id=? AND is_active=1 LIMIT 1");
    $stp->execute([$counterparty_id]);
    $party = $stp->fetch();
    if (!$party) throw new Exception('Cliente/fornecedor inválido.');
    $counterparty_name = (string)$party['name'];

    $description = trim($_POST['description'] ?? '');
    if ($description === '') throw new Exception('Preencha a descrição.');

    $doc_number = trim($_POST['doc_number'] ?? '');
    $notes = trim($_POST['notes'] ?? '');

    $issue_date = $_POST['issue_date'] ?? date('Y-m-d');
    $first_due_date = $_POST['first_due_date'] ?? $issue_date;

    $installments_count = (int)($_POST['installments_count'] ?? 1);
    if ($installments_count < 1 || $installments_count > 120) throw new Exception('Parcelas inválidas.');

    $total_amount = money_to_decimal($_POST['total_amount'] ?? '0,00');
    if ((float)$total_amount <= 0) throw new Exception('Valor total inválido.');

    $default_bank_id = (int)($_POST['default_bank_id'] ?? 0);
    if ($default_bank_id <= 0) throw new Exception('Selecione o banco.');

    $category_id = (int)($_POST['category_id'] ?? 0); if ($category_id<=0) $category_id = null;
    $cost_center_id = (int)($_POST['cost_center_id'] ?? 0); if ($cost_center_id<=0) $cost_center_id = null;
    $account_id = (int)($_POST['account_id'] ?? 0); if ($account_id<=0) $account_id = null;

    $pdo->beginTransaction();

    $pdo->prepare("
      INSERT INTO fin_documents
        (doc_type, counterparty_name, counterparty_id, description, category_id, cost_center_id, account_id, doc_number, notes,
         issue_date, total_amount, installments_count, status, default_bank_id)
      VALUES
        (:doc_type, :counterparty_name, :counterparty_id, :description, :category_id, :cost_center_id, :account_id, :doc_number, :notes,
         :issue_date, :total_amount, :installments_count, 'ABERTO', :default_bank_id)
    ")->execute([
      ':doc_type' => $doc_type,
      ':counterparty_name' => $counterparty_name,
      ':counterparty_id' => $counterparty_id,
      ':description' => $description,
      ':category_id' => $category_id,
      ':cost_center_id' => $cost_center_id,
      ':account_id' => $account_id,
      ':doc_number' => ($doc_number!==''?$doc_number:null),
      ':notes' => ($notes!==''?$notes:null),
      ':issue_date' => $issue_date,
      ':total_amount' => $total_amount,
      ':installments_count' => $installments_count,
      ':default_bank_id' => $default_bank_id,
    ]);
    $docId = (int)$pdo->lastInsertId();

    // gera parcelas mensais a partir da primeira data
    $vals = split_installments($total_amount, $installments_count);
    $d = new DateTime($first_due_date);

    $insInst = $pdo->prepare("
      INSERT INTO fin_installments (document_id, installment_no, due_date, amount, paid_amount, status, bank_id)
      VALUES (?,?,?,?,0,'ABERTO',?)
    ");

    for ($i=1; $i<=$installments_count; $i++) {
      $due = $d->format('Y-m-d');
      $insInst->execute([$docId, $i, $due, $vals[$i-1], $default_bank_id]);
      $d->modify('+1 month');
    }

    if (function_exists('audit_log')) audit_log('create','document',$docId,['type'=>$doc_type,'party_id'=>$counterparty_id,'total'=>$total_amount]);

    $pdo->commit();
    redirect('/contas.php?type='.$doc_type.'&msg=Salvo com sucesso');
  } catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    $err = $e->getMessage();
  }
}

render_header(($type==='PAGAR'?'Conta a Pagar':'Conta a Receber'));
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0"><?=$type==='PAGAR'?'Nova Conta a Pagar':'Nova Conta a Receber'?></h3>
  <a class="btn btn-secondary" href="contas.php?type=<?=$type?>">Voltar</a>
</div>

<?php if ($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<form method="post" class="card shadow-sm p-3">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <input type="hidden" name="doc_type" value="<?=h($type)?>">

  <div class="row g-3">
    <div class="col-md-6">
      <div class="d-flex justify-content-between align-items-center">
        <label class="form-label mb-0"><?=$type==='PAGAR'?'Fornecedor':'Cliente'?> (obrigatório)</label>
        <?php if ($type==='PAGAR'): ?>
          <div class="form-check form-switch ms-2">
            <input class="form-check-input" type="checkbox" id="showClients" name="show_clients" value="1" <?= $showClients ? 'checked' : '' ?>>
            <label class="form-check-label small" for="showClients">Mostrar clientes no pagar</label>
          </div>
        <?php endif; ?>
        <div class="d-flex gap-2 align-items-center">
          <button type="button" class="btn btn-sm btn-outline-dark" id="btnRefreshParties" title="Atualizar lista"><i class="bi bi-arrow-repeat"></i></button>
          <a class="small" href="parties.php?action=new&pref=<?= $type==='PAGAR'?'FORNECEDOR':'CLIENTE' ?>" target="_blank">+ cadastrar</a>
        </div>
      </div>

      <select class="form-select" name="counterparty_id" required>
        <option value="">Selecione...</option>
        <?php foreach ($parties as $p): ?>
          <option value="<?=$p['id']?>" <?= ($prefPartyId>0 && (int)$p['id']===$prefPartyId) ? 'selected' : '' ?>><?=h($p['name'])?></option>
        <?php endforeach; ?>
      </select>
      <div class="form-text">Se não existir, use “+ cadastrar”.</div>
    </div>

    <div class="col-md-6">
      <label class="form-label">Descrição</label>
      <input class="form-control" name="description" required>
    </div>

    <div class="col-md-3">
      <label class="form-label">Nº Doc (opcional)</label>
      <input class="form-control" name="doc_number">
    </div>

    <div class="col-md-3">
      <label class="form-label">Data emissão</label>
      <input class="form-control" type="date" name="issue_date" value="<?=h(date('Y-m-d'))?>">
    </div>

    <div class="col-md-3">
      <label class="form-label">1º vencimento</label>
      <input class="form-control" type="date" name="first_due_date" value="<?=h(date('Y-m-d'))?>">
    </div>

    <div class="col-md-3">
      <label class="form-label">Parcelas</label>
      <input class="form-control" type="number" name="installments_count" min="1" max="120" value="1">
    </div>

    <div class="col-md-3">
      <label class="form-label">Valor total</label>
      <input class="form-control" name="total_amount" data-money="brl" placeholder="R$ 0,00" required>
    </div>

    <div class="col-md-3">
      <label class="form-label">Banco</label>
      <select class="form-select" name="default_bank_id" required>
        <option value="">Selecione...</option>
        <?php foreach($banks as $b): ?>
          <option value="<?=$b['id']?>"><?=h($b['bank_name'])?> (<?=h($b['bank_number'])?>) Ag <?=h($b['agency'])?> Cc <?=h($b['account_number'])?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">Categoria</label>
      <select class="form-select" name="category_id">
        <option value="">(opcional)</option>
        <?php foreach($cats as $c): ?>
          <?php
            $ok = ($type==='PAGAR' && ($c['type']==='PAGAR' || $c['type']==='AMBOS')) ||
                  ($type==='RECEBER' && ($c['type']==='RECEBER' || $c['type']==='AMBOS'));
          ?>
          <?php if($ok): ?><option value="<?=$c['id']?>"><?=h($c['name'])?></option><?php endif; ?>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">Centro de custo</label>
      <select class="form-select" name="cost_center_id">
        <option value="">(opcional)</option>
        <?php foreach($ccs as $c): ?><option value="<?=$c['id']?>"><?=h($c['name'])?></option><?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">Plano de contas</label>
      <select class="form-select" name="account_id">
        <option value="">(opcional)</option>
        <?php foreach($accounts as $a): ?><option value="<?=$a['id']?>"><?=h($a['code'])?> — <?=h($a['name'])?></option><?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-12">
      <label class="form-label">Observações</label>
      <input class="form-control" name="notes">
    </div>
  </div>

  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-primary ripple-target">Salvar</button>
  </div>
</form>

<script>
(function(){
  const sw = document.getElementById('showClients');
  if (sw) {
    sw.addEventListener('change', () => {
      const v = sw.checked ? '1' : '0';
      document.cookie = 'show_clients_pagar=' + v + '; path=/';
      const u = new URL(window.location.href);
      u.searchParams.set('show_clients', v);
      window.location.href = u.toString();
    });
  }

  const btn = document.getElementById('btnRefreshParties');
  const sel = document.querySelector('select[name="counterparty_id"]');
  if(!btn || !sel) return;

  btn.addEventListener('click', async () => {
    const old = sel.value;
    btn.disabled = true;
    btn.innerHTML = '<span class="spinner-border spinner-border-sm"></span>';
    try{
      let url = 'api_parties.php?type=<?= $type ?>';
      const show = (document.getElementById('showClients')?.checked) ? 1 : <?= ($type==='PAGAR' ? $showClients : 0) ?>;
      if ('<?= $type ?>' === 'PAGAR') url += '&show_clients=' + show;

      const res = await fetch(url, {headers: {'Accept':'application/json'}});
      const json = await res.json();
      if(!json.ok) throw new Error('Falha ao carregar');

      const items = json.items || [];
      sel.innerHTML = '<option value="">Selecione...</option>';
      for(const it of items){
        const opt = document.createElement('option');
        opt.value = it.id;
        opt.textContent = it.name;
        sel.appendChild(opt);
      }
      if (old) sel.value = old;
    }catch(e){
      alert('Não foi possível atualizar a lista.');
    }finally{
      btn.disabled = false;
      btn.innerHTML = '<i class="bi bi-arrow-repeat"></i>';
    }
  });
})();
</script>

<?php render_footer(); ?>
