<?php
require __DIR__ . '/_init.php';
require_login();
require_perm('categories','view');

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if ($action === 'create') { require_perm('categories','create');
      $name = trim($_POST['name'] ?? '');
      $type = $_POST['type'] ?? 'AMBOS';
      if ($name === '') throw new Exception('Informe o nome.');
      if (!in_array($type, ['PAGAR','RECEBER','AMBOS'], true)) $type = 'AMBOS';

      $pdo->prepare("INSERT INTO fin_categories (name, type) VALUES (?, ?)")->execute([$name, $type]);
      audit_log('create','category',$pdo->lastInsertId(),['name'=>$name,'type'=>$type]);
      redirect('/categories.php?msg=Categoria criada');
    }

    if ($action === 'edit') { require_perm('categories','edit');
      $id = (int)($_POST['id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $type = $_POST['type'] ?? 'AMBOS';
      $is_active = (int)($_POST['is_active'] ?? 1);

      if ($name === '') throw new Exception('Informe o nome.');
      if (!in_array($type, ['PAGAR','RECEBER','AMBOS'], true)) $type = 'AMBOS';

      $pdo->prepare("
        UPDATE fin_categories
        SET name=?, type=?, is_active=?, updated_at=NOW()
        WHERE id=?
      ")->execute([$name, $type, $is_active, $id]);

      audit_log('edit','category',$id,[]);
      redirect('/categories.php?msg=Categoria atualizada');
    }
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

render_header('Categorias');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if ($action === 'new') { ?>
  <h3>Nova Categoria</h3>
  <form method="post" action="categories.php?action=create" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Aplicação</label>
        <select class="form-select" name="type">
          <option value="AMBOS">Ambos</option>
          <option value="PAGAR">Somente Pagar</option>
          <option value="RECEBER">Somente Receber</option>
        </select>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="categories.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

if ($action === 'editform') {
  $id = (int)($_GET['id'] ?? 0);
  $st = $pdo->prepare("SELECT * FROM fin_categories WHERE id=?");
  $st->execute([$id]);
  $c = $st->fetch();
  if (!$c) { echo '<div class="alert alert-danger">Categoria não encontrada.</div>'; render_footer(); exit; }
  ?>
  <h3>Editar Categoria</h3>
  <form method="post" action="categories.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$c['id'])?>">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?=h($c['name'])?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Aplicação</label>
        <select class="form-select" name="type">
          <option value="AMBOS" <?=$c['type']==='AMBOS'?'selected':''?>>Ambos</option>
          <option value="PAGAR" <?=$c['type']==='PAGAR'?'selected':''?>>Somente Pagar</option>
          <option value="RECEBER" <?=$c['type']==='RECEBER'?'selected':''?>>Somente Receber</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">Ativa?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=$c['is_active']?'selected':''?>>Sim</option>
          <option value="0" <?=!$c['is_active']?'selected':''?>>Não</option>
        </select>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="categories.php">Voltar</a>
    </div>
  </form>
<?php render_footer(); exit; }

$cats = $pdo->query("SELECT * FROM fin_categories ORDER BY name")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Categorias</h3>
  
  <div class="listview-toggle">
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="grid" title="Grade"><i class="bi bi-grid-3x3-gap"></i></button>
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="compact" title="Compacto"><i class="bi bi-list"></i></button>
  </div>
<?php if (perm_can('categories','create')): ?>
<a class="btn btn-primary" href="categories.php?action=new">+ Nova Categoria</a>
<?php endif; ?>
</div>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead class="table-dark">
        <tr>
          <th>Nome</th><th>Aplicação</th><th>Status</th><th style="width:140px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($cats as $c): ?>
          <tr>
            <td><?=h($c['name'])?></td>
            <td><?=h($c['type'])?></td>
            <td><?= $c['is_active'] ? '<span class="badge bg-success glow-badge">Ativa</span>' : '<span class="badge bg-secondary">Inativa</span>' ?></td>
            <td class="text-end">
              <?php if (perm_can('categories','edit')): ?>
<a class="btn btn-sm btn-outline-primary" href="categories.php?action=editform&id=<?=$c['id']?>">Editar</a>
<?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$cats): ?>
          <tr><td colspan="4" class="text-center text-muted py-4">Nenhuma categoria.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php render_footer(); ?>
