<?php
require __DIR__ . '/_init.php';
require_login();
require_perm('banks','view');

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  try {
    if ($action === 'create') { require_perm('banks','create');
      $bank_number = trim($_POST['bank_number'] ?? '');
      $bank_name   = trim($_POST['bank_name'] ?? '');
      $agency      = trim($_POST['agency'] ?? '');
      $account_number = trim($_POST['account_number'] ?? '');
      $account_type = $_POST['account_type'] ?? 'corrente';
      $initial_balance = money_to_decimal($_POST['initial_balance'] ?? '0');

      if ($bank_number === '' || $bank_name === '' || $agency === '' || $account_number === '') throw new Exception('Preencha todos os campos.');

      $stmt = $pdo->prepare("
        INSERT INTO banks (bank_number, bank_name, agency, account_number, account_type, initial_balance, current_balance)
        VALUES (?, ?, ?, ?, ?, ?, ?)
      ");
      $stmt->execute([$bank_number, $bank_name, $agency, $account_number, $account_type, $initial_balance, $initial_balance]);

      audit_log('create','bank',$pdo->lastInsertId(),['bank_number'=>$bank_number,'agency'=>$agency]);
      redirect('/banks.php?msg=Banco criado com sucesso');
    }

    if ($action === 'edit') { require_perm('banks','edit');
      $id = (int)($_POST['id'] ?? 0);
      $bank_number = trim($_POST['bank_number'] ?? '');
      $bank_name   = trim($_POST['bank_name'] ?? '');
      $agency      = trim($_POST['agency'] ?? '');
      $account_number = trim($_POST['account_number'] ?? '');
      $account_type = $_POST['account_type'] ?? 'corrente';

      $stmt = $pdo->prepare("
        UPDATE banks
        SET bank_number=?, bank_name=?, agency=?, account_number=?, account_type=?, updated_at=NOW()
        WHERE id=?
      ");
      $stmt->execute([$bank_number, $bank_name, $agency, $account_number, $account_type, $id]);

      audit_log('edit','bank',$id,[]);
      redirect('/banks.php?msg=Banco atualizado');
    }

    if ($action === 'delete') { require_perm('banks','delete');
      $id = (int)($_POST['id'] ?? 0);

      $chk = $pdo->prepare("SELECT COUNT(*) FROM fin_installments WHERE bank_id=?");
      $chk->execute([$id]);
      if ((int)$chk->fetchColumn() > 0) throw new Exception('Não é possível excluir: banco possui parcelas/movimentações.');

      $pdo->prepare("DELETE FROM banks WHERE id=?")->execute([$id]);
      audit_log('delete','bank',$id,[]);
      redirect('/banks.php?msg=Banco excluído');
    }
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

render_header('Bancos');

if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if ($action === 'new') {
  ?>
  <h3>Novo Banco</h3>
  <form method="post" action="banks.php?action=create" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row g-3">
      <div class="col-md-2">
        <label class="form-label">Nº Banco</label>
        <input class="form-control" name="bank_number" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Nome</label>
        <input class="form-control" name="bank_name" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Agência</label>
        <input class="form-control" name="agency" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Conta</label>
        <input class="form-control" name="account_number" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Tipo</label>
        <select class="form-select" name="account_type" required>
          <option value="corrente">Corrente</option>
          <option value="poupanca">Poupança</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Saldo inicial</label>
        <input class="form-control" name="initial_balance" data-money="brl" placeholder="R$ 0,00" required>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="banks.php">Cancelar</a>
    </div>
  </form>
  <?php
  render_footer(); exit;
}

if ($action === 'editform') {
  $id = (int)($_GET['id'] ?? 0);
  $stmt = $pdo->prepare("SELECT * FROM banks WHERE id=?");
  $stmt->execute([$id]);
  $b = $stmt->fetch();
  if (!$b) { echo '<div class="alert alert-danger">Banco não encontrado.</div>'; render_footer(); exit; }
  ?>
  <h3>Editar Banco</h3>
  <form method="post" action="banks.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$b['id'])?>">
    <div class="row g-3">
      <div class="col-md-2">
        <label class="form-label">Nº Banco</label>
        <input class="form-control" name="bank_number" value="<?=h($b['bank_number'])?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Nome</label>
        <input class="form-control" name="bank_name" value="<?=h($b['bank_name'])?>" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Agência</label>
        <input class="form-control" name="agency" value="<?=h($b['agency'])?>" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Conta</label>
        <input class="form-control" name="account_number" value="<?=h($b['account_number'])?>" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Tipo</label>
        <select class="form-select" name="account_type">
          <option value="corrente" <?=$b['account_type']==='corrente'?'selected':''?>>Corrente</option>
          <option value="poupanca" <?=$b['account_type']==='poupanca'?'selected':''?>>Poupança</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Saldo atual</label>
        <input class="form-control" value="R$ <?=h(number_format((float)$b['current_balance'],2,',','.'))?>" disabled>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="banks.php">Voltar</a>
    </div>
  </form>
  <?php
  render_footer(); exit;
}

$banks = $pdo->query("SELECT * FROM banks ORDER BY bank_name")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Bancos</h3>
  
  <div class="listview-toggle">
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="grid" title="Grade"><i class="bi bi-grid-3x3-gap"></i></button>
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="compact" title="Compacto"><i class="bi bi-list"></i></button>
  </div>
<?php if (perm_can('banks','create')): ?>
  <a class="btn btn-primary" href="banks.php?action=new">+ Novo Banco</a>
<?php endif; ?>
</div>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead class="table-dark">
        <tr>
          <th>Banco</th><th>Agência</th><th>Tipo</th><th class="text-end">Saldo atual</th><th style="width:220px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($banks as $b): ?>
          <tr>
            <td><?=h($b['bank_name'])?> (<?=h($b['bank_number'])?>)</td>
            <td><?=h($b['agency'])?></td>
            <td><?=h($b['account_type'])?></td>
            <td class="text-end">R$ <?=h(number_format((float)$b['current_balance'],2,',','.'))?></td>
            <td class="text-end">
              <?php if (perm_can('banks','edit')): ?>
<a class="btn btn-sm btn-outline-primary" href="banks.php?action=editform&id=<?=$b['id']?>">Editar</a>
<?php endif; ?>
              <form method="post" action="banks.php?action=delete" class="d-inline" onsubmit="return confirm('Excluir banco?');">
                <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
                <input type="hidden" name="id" value="<?=h((string)$b['id'])?>">
                <?php if (perm_can('banks','delete')): ?>
<button class="btn btn-sm btn-outline-danger">Excluir</button>
<?php endif; ?>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$banks): ?>
          <tr><td colspan="5" class="text-center text-muted py-4">Nenhum banco cadastrado.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php render_footer(); ?>
