<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin');
require_perm('audit_logs','view');

$pdo = db();

$start = $_GET['start'] ?? date('Y-m-01');
$end = $_GET['end'] ?? date('Y-m-t');
$q = trim($_GET['q'] ?? '');
$userId = (int)($_GET['user_id'] ?? 0);

$users = $pdo->query("SELECT id,name,email FROM users ORDER BY name")->fetchAll();

$where = "created_at BETWEEN :s AND :e";
$params = [':s'=>$start.' 00:00:00', ':e'=>$end.' 23:59:59'];

if ($userId>0) { $where .= " AND user_id=:uid"; $params[':uid']=$userId; }
if ($q!=='') { $where .= " AND (action LIKE :q OR entity LIKE :q OR COALESCE(entity_id,'') LIKE :q)"; $params[':q']="%{$q}%"; }

$st = $pdo->prepare("SELECT * FROM audit_logs WHERE {$where} ORDER BY id DESC LIMIT 500");
$st->execute($params);
$rows = $st->fetchAll();

render_header('Auditoria');
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Auditoria</h3>
  <div class="text-muted small">Últimos 500 registros do filtro</div>
</div>

<form class="card shadow-sm p-3 mb-3" method="get">
  <div class="row g-3 align-items-end">
    <div class="col-md-2">
      <label class="form-label">Início</label>
      <input class="form-control" type="date" name="start" value="<?=h($start)?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">Fim</label>
      <input class="form-control" type="date" name="end" value="<?=h($end)?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">Usuário</label>
      <select class="form-select" name="user_id">
        <option value="0">Todos</option>
        <?php foreach($users as $u): ?>
          <option value="<?=$u['id']?>" <?=$userId===(int)$u['id']?'selected':''?>><?=h($u['name'])?> (<?=h($u['email'])?>)</option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Filtro</label>
      <input class="form-control" name="q" value="<?=h($q)?>" placeholder="action/entity/id">
    </div>
    <div class="col-md-2 d-grid">
      <button class="btn btn-outline-dark">Aplicar</button>
    </div>
  </div>
</form>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-sm table-striped mb-0 align-middle">
      <thead class="table-dark">
        <tr>
          <th>Data</th><th>User</th><th>Ação</th><th>Entidade</th><th>ID</th><th>IP</th><th>Meta</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?=h(date('d/m/Y H:i:s', strtotime($r['created_at'])))?></td>
            <td><?=h((string)($r['user_id'] ?? '—'))?></td>
            <td><?=h($r['action'])?></td>
            <td><?=h($r['entity'])?></td>
            <td><?=h((string)($r['entity_id'] ?? ''))?></td>
            <td><?=h((string)($r['ip'] ?? ''))?></td>
            <td class="text-muted small"><?=h((string)($r['meta_json'] ?? ''))?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="7" class="text-center text-muted py-4">Sem registros.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php render_footer(); ?>
