<?php
require __DIR__.'/_init.php';
require_login();
require_perm('assistant_ai','view');

require __DIR__.'/../app/ai/openai_client.php';
require __DIR__.'/../app/ai/gemini_client.php';
require __DIR__.'/../app/ai/json_tools.php';

$pdo = db();

$start = $_GET['start'] ?? date('Y-m-01');
$end   = $_GET['end'] ?? date('Y-m-t');
$provider = $_GET['provider'] ?? (string)setting_get('ai.provider_default','openai');
$objective = trim($_GET['objective'] ?? '');
$promptId = (int)($_GET['prompt_id'] ?? 0);

$prompts = $pdo->query("
  SELECT p.id, p.name, p.body, c.name AS cat_name
  FROM prompts p
  JOIN prompt_categories c ON c.id=p.category_id
  WHERE p.is_active=1 AND c.is_active=1
  ORDER BY c.name, p.name
")->fetchAll();

$err=''; $result=null; $reportId=null;

function query_all(PDO $pdo, string $sql, array $params): array {
  $st=$pdo->prepare($sql);
  $st->execute($params);
  return $st->fetchAll();
}

if(isset($_GET['run']) && $_GET['run']==='1'){
  try{
    require_perm('assistant_ai','create');

    if ($promptId <= 0) throw new Exception('Selecione um prompt antes de analisar.');

    $stpr = $pdo->prepare("SELECT id, name, body FROM prompts WHERE id=? AND is_active=1 LIMIT 1");
    $stpr->execute([$promptId]);
    $promptRow = $stpr->fetch();
    if (!$promptRow) throw new Exception('Prompt inválido.');

    $pStart = $start.' 00:00:00';
    $pEnd   = $end.' 23:59:59';

    // Totais realizados
    $real = $pdo->prepare("
      SELECT
        SUM(CASE WHEN entry_type='CREDITO' THEN amount ELSE 0 END) AS entradas,
        SUM(CASE WHEN entry_type='DEBITO' THEN amount ELSE 0 END) AS saidas
      FROM bank_ledger
      WHERE occurred_at BETWEEN ? AND ?
    ");
    $real->execute([$pStart,$pEnd]);
    $realRow=$real->fetch() ?: ['entradas'=>0,'saidas'=>0];

    // Previsto (parcelas abertas por vencimento)
    $prev = $pdo->prepare("
      SELECT
        SUM(CASE WHEN d.doc_type='RECEBER' THEN (i.amount - i.paid_amount) ELSE 0 END) AS recv,
        SUM(CASE WHEN d.doc_type='PAGAR' THEN (i.amount - i.paid_amount) ELSE 0 END) AS pay
      FROM fin_installments i
      JOIN fin_documents d ON d.id=i.document_id
      WHERE i.status IN ('ABERTO','PARCIAL')
        AND i.due_date BETWEEN ? AND ?
    ");
    $prev->execute([$start,$end]);
    $prevRow=$prev->fetch() ?: ['recv'=>0,'pay'=>0];

    // Por centro de custo (realizado)
    $byCC = query_all($pdo, "
      SELECT COALESCE(cc.name,'(sem centro)') AS nome,
        SUM(CASE WHEN bl.entry_type='CREDITO' THEN bl.amount ELSE 0 END) AS entradas,
        SUM(CASE WHEN bl.entry_type='DEBITO' THEN bl.amount ELSE 0 END) AS saidas
      FROM bank_ledger bl
      JOIN fin_settlements s ON s.id=bl.settlement_id
      JOIN fin_installments i ON i.id=s.installment_id
      JOIN fin_documents d ON d.id=i.document_id
      LEFT JOIN fin_cost_centers cc ON cc.id=d.cost_center_id
      WHERE bl.occurred_at BETWEEN ? AND ?
      GROUP BY nome
      ORDER BY nome
    ", [$pStart,$pEnd]);

    // Por conta (plano de contas) realizado
    $byAcc = query_all($pdo, "
      SELECT COALESCE(a.code,'(sem)') AS code, COALESCE(a.name,'(sem conta)') AS name, COALESCE(a.type,'') AS type,
        SUM(CASE WHEN bl.entry_type='CREDITO' THEN bl.amount ELSE 0 END) AS entradas,
        SUM(CASE WHEN bl.entry_type='DEBITO' THEN bl.amount ELSE 0 END) AS saidas
      FROM bank_ledger bl
      JOIN fin_settlements s ON s.id=bl.settlement_id
      JOIN fin_installments i ON i.id=s.installment_id
      JOIN fin_documents d ON d.id=i.document_id
      LEFT JOIN fin_accounts a ON a.id=d.account_id
      WHERE bl.occurred_at BETWEEN ? AND ?
      GROUP BY code, name, type
      ORDER BY code
    ", [$pStart,$pEnd]);

    // Saldos por banco
    $bankBalances = $pdo->query("SELECT bank_name, bank_number, current_balance FROM banks ORDER BY bank_name")->fetchAll();

    $data = [
      "periodo" => ["inicio"=>$start,"fim"=>$end],
      "realizado" => ["entradas"=>(float)$realRow['entradas'], "saidas"=>(float)$realRow['saidas']],
      "previsto" => ["entradas"=>(float)$prevRow['recv'], "saidas"=>(float)$prevRow['pay']],
      "por_centro_custo" => $byCC,
      "por_conta" => $byAcc,
      "saldos_bancos" => $bankBalances,
      "objetivo_usuario" => $objective,
    ];

    $dataJson = json_encode($data, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);

    $tpl = (string)$promptRow['body'];
    if (strpos($tpl, '{{DATA_JSON}}') !== false) {
      $prompt = str_replace('{{DATA_JSON}}', $dataJson, $tpl);
    } else {
      $prompt = rtrim($tpl) . "\n\nDADOS (JSON):\n" . $dataJson;
    }

    if(!in_array($provider,['openai','gemini'],true)) $provider='openai';

    if($provider==='openai'){
      $model = (string)setting_get('openai.model','gpt-5');
      $raw = openai_generate_text($model, $prompt, 0.2);
    } else {
      $model = (string)setting_get('gemini.model','gemini-1.5-pro');
      $raw = gemini_generate_text($model, $prompt);
    }

    $parsed = extract_first_json_object($raw);

    $hash = hash('sha256', $prompt);
    $pdo->prepare("
      INSERT INTO ai_reports (user_id, provider, period_start, period_end, prompt_id, prompt_name, prompt_body, prompt_hash, result_json)
      VALUES (?,?,?,?,?,?,?,?,?)
    ")->execute([
      (int)$_SESSION['user_id'],
      $provider,
      $start,
      $end,
      (int)$promptRow['id'],
      (string)$promptRow['name'],
      (string)$promptRow['body'],
      $hash,
      json_encode($parsed, JSON_UNESCAPED_UNICODE)
    ]);

    audit_log('create','ai_report',$reportId,['provider'=>$provider,'prompt_id'=>(int)$promptRow['id']]);
    $reportId = (int)$pdo->lastInsertId();
    $result = $parsed;

  } catch(Throwable $e){
    $err = $e->getMessage();
  }
}

render_header('Assistente IA');
?>
<h3 class="mb-3">Assistente Financeiro com IA</h3>
<?php if($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<form class="card shadow-sm p-3 mb-3" method="get">
  <div class="row g-3 align-items-end">
    <div class="col-md-4">
      <label class="form-label">Prompt</label>
      <select class="form-select" name="prompt_id" required>
        <option value="">Selecione...</option>
        <?php foreach ($prompts as $pr): ?>
          <option value="<?=$pr['id']?>" <?=(int)$promptId===(int)$pr['id']?'selected':''?>><?=h($pr['cat_name'])?> — <?=h($pr['name'])?></option>
        <?php endforeach; ?>
      </select>
      <div class="form-text"><a href="prompts.php" target="_blank">Gerenciar prompts</a></div>
    </div>

    <div class="col-md-2">
      <label class="form-label">Início</label>
      <input class="form-control" type="date" name="start" value="<?=h($start)?>">
    </div>
    <div class="col-md-2">
      <label class="form-label">Fim</label>
      <input class="form-control" type="date" name="end" value="<?=h($end)?>">
    </div>

    <div class="col-md-2">
      <label class="form-label">Provider</label>
      <select class="form-select" name="provider">
        <option value="openai" <?=$provider==='openai'?'selected':''?>>OpenAI</option>
        <option value="gemini" <?=$provider==='gemini'?'selected':''?>>Gemini</option>
      </select>
    </div>

    <div class="col-md-2">
      <label class="form-label">Objetivo</label>
      <input class="form-control" name="objective" value="<?=h($objective)?>" placeholder="Opcional">
    </div>
  </div>

  <input type="hidden" name="run" value="1">
  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-primary ripple-target">Analisar</button>
    <a class="btn btn-outline-dark ripple-target" href="ia_settings.php">Config IA (APIs)</a>
  </div>
</form>

<?php if($result): ?>
  <div class="row g-3 mb-3">
    <div class="col-md-4">
      <div class="card shadow-sm"><div class="card-body">
        <div class="text-muted">Score</div>
        <div class="display-6 fw-bold"><?=h((string)($result['score_saude_financeira'] ?? '—'))?></div>
        <div class="badge bg-dark"><?=h((string)($result['classificacao'] ?? '—'))?></div>
      </div></div>
    </div>
    <div class="col-md-8">
      <div class="card shadow-sm"><div class="card-body">
        <div class="text-muted">Resumo executivo</div>
        <div><?=h((string)($result['resumo_executivo'] ?? ''))?></div>
      </div></div>
    </div>
  </div>

  <div class="card shadow-sm mb-3"><div class="card-body">
    <h5 class="mb-2">Pontos fracos</h5>
    <ul class="mb-0">
      <?php foreach(($result['pontos_fracos'] ?? []) as $x): ?>
        <li><?=h((string)$x)?></li>
      <?php endforeach; ?>
    </ul>
  </div></div>

  <div class="d-flex gap-2">
    <a class="btn btn-outline-dark ripple-target" href="assistant_pdf.php?id=<?=$reportId?>">Gerar PDF</a>
  </div>
<?php endif; ?>

<?php render_footer(); ?>
