<?php
// app/settings.php
require_once __DIR__ . '/db.php';

function app_key(): string {
  $cfg = require __DIR__ . '/config.php';
  return (string)($cfg['app']['app_key'] ?? '');
}

function encrypt_secret(string $plain): string {
  $key = hash('sha256', app_key(), true);
  $iv = random_bytes(12);
  $tag = '';
  $cipher = openssl_encrypt($plain, 'aes-256-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag);
  return base64_encode($iv.$tag.$cipher);
}

function decrypt_secret(string $enc): string {
  $raw = base64_decode($enc, true);
  if ($raw === false || strlen($raw) < 12+16+1) return '';
  $key = hash('sha256', app_key(), true);
  $iv = substr($raw, 0, 12);
  $tag = substr($raw, 12, 16);
  $cipher = substr($raw, 28);
  $plain = openssl_decrypt($cipher, 'aes-256-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag);
  return $plain === false ? '' : $plain;
}

function setting_get(string $k, $default=null) {
  $pdo = db();
  $st = $pdo->prepare("SELECT v, is_secret FROM app_settings WHERE k=?");
  $st->execute([$k]);
  $r = $st->fetch();
  if (!$r) return $default;
  if ((int)$r['is_secret'] === 1) return decrypt_secret((string)$r['v']);
  return $r['v'];
}

function setting_set(string $k, ?string $v, bool $secret=false): void {
  $pdo = db();
  $val = $v;
  $is_secret = $secret ? 1 : 0;
  if ($secret && $v !== null) $val = encrypt_secret($v);

  $pdo->prepare("
    INSERT INTO app_settings (k,v,is_secret) VALUES (?,?,?)
    ON DUPLICATE KEY UPDATE v=VALUES(v), is_secret=VALUES(is_secret)
  ")->execute([$k, $val, $is_secret]);
}
