<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin','finance');
require_perm('prompts','view');

$pdo=db();
$action=$_GET['action'] ?? 'list';
$msg=$_GET['msg'] ?? '';
$err='';

$cats = $pdo->query("SELECT id,name FROM prompt_categories WHERE is_active=1 ORDER BY name")->fetchAll();

$pdo = $pdo; // keep


if ($action === 'clone') {
  require_perm('prompts','create');
  $id = (int)($_GET['id'] ?? 0);
  $st = $pdo->prepare("SELECT * FROM prompts WHERE id=?");
  $st->execute([$id]);
  $p = $st->fetch();
  if (!$p) redirect('/prompts.php?msg=Prompt não encontrado');

  $newName = $p['name'].' (Cópia '.date('d-m H:i').')';
  $pdo->prepare("INSERT INTO prompts (category_id, name, body, is_active) VALUES (?,?,?,1)")
      ->execute([(int)$p['category_id'], $newName, (string)$p['body']]);

  $newId = (int)$pdo->lastInsertId();
  audit_log('clone','prompt',$newId,['from'=>$id,'name'=>$newName]);
  redirect('/prompts.php?msg=Prompt duplicado');
}


if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  try{
    if($action==='create'){ require_perm('prompts','create');
      $category_id = (int)($_POST['category_id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $body = trim($_POST['body'] ?? '');
      if ($category_id<=0) throw new Exception('Selecione a categoria.');
      if ($name==='' || $body==='') throw new Exception('Nome e prompt são obrigatórios.');
      $pdo->prepare("INSERT INTO prompts (category_id,name,body) VALUES (?,?,?)")->execute([$category_id,$name,$body]);
      redirect('/prompts.php?msg=Prompt criado');
    }
    if($action==='edit'){ require_perm('prompts','edit');
      $id=(int)($_POST['id'] ?? 0);
      $category_id = (int)($_POST['category_id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $body = trim($_POST['body'] ?? '');
      $is_active = (int)($_POST['is_active'] ?? 1);
      if ($id<=0) throw new Exception('ID inválido.');
      if ($category_id<=0) throw new Exception('Selecione a categoria.');
      if ($name==='' || $body==='') throw new Exception('Nome e prompt são obrigatórios.');
      $pdo->prepare("UPDATE prompts SET category_id=?, name=?, body=?, is_active=?, updated_at=NOW() WHERE id=?")
          ->execute([$category_id,$name,$body,$is_active,$id]);
      redirect('/prompts.php?msg=Prompt atualizado');
    }
  }catch(Throwable $e){ $err=$e->getMessage(); }
}

render_header('Prompts');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if($action==='new'){
  if(!$cats){ echo '<div class="alert alert-warning">Crie uma categoria antes.</div>'; render_footer(); exit; }
?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Novo prompt</h3>
    <a class="btn btn-secondary" href="prompts.php">Voltar</a>
  </div>

  <form method="post" action="prompts.php?action=create" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Categoria</label>
        <select class="form-select" name="category_id" required>
          <option value="">Selecione...</option>
          <?php foreach($cats as $c): ?><option value="<?=$c['id']?>"><?=h($c['name'])?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-8">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" required>
      </div>
      <div class="col-md-12">
        <label class="form-label">Prompt</label>
        <textarea class="form-control" name="body" rows="10" required placeholder="Use {{DATA_JSON}} para inserir os dados."></textarea>
        <div class="form-text">Se não usar {{DATA_JSON}}, o sistema anexa os dados no final.</div>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="prompts.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

if($action==='editform'){
  $id=(int)($_GET['id'] ?? 0);
  $st=$pdo->prepare("SELECT * FROM prompts WHERE id=?");
  $st->execute([$id]);
  $p=$st->fetch();
  if(!$p){ echo '<div class="alert alert-danger">Prompt não encontrado.</div>'; render_footer(); exit; }
?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Editar prompt</h3>
    <a class="btn btn-secondary" href="prompts.php">Voltar</a>
  </div>

  <form method="post" action="prompts.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$p['id'])?>">
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Categoria</label>
        <select class="form-select" name="category_id" required>
          <?php foreach($cats as $c): ?>
            <option value="<?=$c['id']?>" <?=(int)$p['category_id']===(int)$c['id']?'selected':''?>><?=h($c['name'])?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?=h($p['name'])?>" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Ativo?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=(int)$p['is_active']===1?'selected':''?>>Sim</option>
          <option value="0" <?=(int)$p['is_active']===0?'selected':''?>>Não</option>
        </select>
      </div>
      <div class="col-md-12">
        <label class="form-label">Prompt</label>
        <textarea class="form-control" name="body" rows="10" required><?=h($p['body'])?></textarea>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="prompts.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

$rows=$pdo->query("SELECT p.*, c.name AS cat_name FROM prompts p JOIN prompt_categories c ON c.id=p.category_id ORDER BY c.name, p.name")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Prompts</h3>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-dark" href="prompt_categories.php">Categorias</a>
    <a class="btn btn-primary" href="prompts.php?action=new">+ Novo</a>
  </div>
</div>

<div class="row g-3">
  <?php foreach($rows as $r): ?>
    <div class="col-md-4">
      <div class="list-card" data-tilt>
        <div class="d-flex justify-content-between align-items-start">
          <div>
            <div class="list-title"><?=h($r['name'])?></div>
            <div class="list-sub"><?=h($r['cat_name'])?></div>
          </div>
          <div><?= ((int)$r['is_active']===1) ? '<span class="badge bg-success glow-badge">Ativo</span>' : '<span class="badge bg-secondary">Inativo</span>' ?></div>
        </div>
        <div class="meta-item mt-2">
          <div class="meta-label">Preview</div>
          <div class="meta-value"><?=h(mb_substr($r['body'],0,140,'UTF-8'))?>...</div>
        </div>
        <div class="list-actions">
          <a class="btn btn-sm btn-outline-primary" href="prompts.php?action=editform&id=<?=$r['id']?>">Editar</a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
  <?php if(!$rows): ?><div class="col-12"><div class="alert alert-warning mb-0">Nenhum prompt.</div></div><?php endif; ?>
</div>

<?php render_footer(); ?>
