<?php
require __DIR__ . '/_init.php';
require_login();

$pdo = db();
$userId = (int)($_SESSION['user_id'] ?? 0);

$st = $pdo->prepare("SELECT id, name, email FROM users WHERE id=? LIMIT 1");
$st->execute([$userId]);
$u = $st->fetch();
if (!$u) { http_response_code(404); die('Usuário não encontrado.'); }

$msg=''; $err='';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $curPass = $_POST['current_password'] ?? '';
    $newPass = $_POST['new_password'] ?? '';
    $newPass2 = $_POST['new_password2'] ?? '';

    if ($name === '' || $email === '') throw new Exception('Nome e e-mail são obrigatórios.');

    $emailChanged = (strcasecmp($email, $u['email']) !== 0);

    if ($emailChanged || ($newPass !== '')) {
      if ($curPass === '') throw new Exception('Informe sua senha atual para salvar alterações.');
      $stp = $pdo->prepare("SELECT password_hash FROM users WHERE id=?");
      $stp->execute([$userId]);
      $hash = (string)$stp->fetchColumn();
      if (!$hash || !password_verify($curPass, $hash)) throw new Exception('Senha atual inválida.');
    }

    $stc = $pdo->prepare("SELECT COUNT(*) FROM users WHERE LOWER(email)=LOWER(?) AND id<>?");
    $stc->execute([$email, $userId]);
    if ((int)$stc->fetchColumn() > 0) throw new Exception('Este e-mail já está em uso.');

    if ($newPass !== '') {
      if (strlen($newPass) < 8) throw new Exception('Nova senha deve ter no mínimo 8 caracteres.');
      if ($newPass !== $newPass2) throw new Exception('Confirmação de senha não confere.');
    }

    $pdo->beginTransaction();
    $pdo->prepare("UPDATE users SET name=?, email=? WHERE id=?")->execute([$name, $email, $userId]);

    if ($newPass !== '') {
      $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([password_hash($newPass, PASSWORD_BCRYPT), $userId]);
    }

    $pdo->commit();

    $_SESSION['user_name'] = $name;
    $msg = 'Perfil atualizado.';

    $st->execute([$userId]);
    $u = $st->fetch();
  } catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    $err = $e->getMessage();
  }
}

render_header('Perfil');
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Meu perfil</h3>
  <a class="btn btn-secondary" href="index.php">Voltar</a>
</div>

<?php if ($msg): ?><div class="alert alert-success"><?=h($msg)?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<form method="post" class="card shadow-sm p-3" style="max-width:820px">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">

  <div class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Nome</label>
      <input class="form-control" name="name" value="<?=h($u['name'])?>" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">E-mail</label>
      <input class="form-control" name="email" type="email" value="<?=h($u['email'])?>" required>
      <div class="form-text">Alterar e-mail exige senha atual.</div>
    </div>

    <div class="col-md-6">
      <label class="form-label">Senha atual</label>
      <input class="form-control" name="current_password" type="password" placeholder="Obrigatória para trocar e-mail/senha">
    </div>

    <div class="col-md-3">
      <label class="form-label">Nova senha</label>
      <input class="form-control" name="new_password" type="password" placeholder="Opcional">
    </div>
    <div class="col-md-3">
      <label class="form-label">Confirmar senha</label>
      <input class="form-control" name="new_password2" type="password" placeholder="Opcional">
    </div>
  </div>

  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-primary">Salvar</button>
  </div>
</form>

<?php render_footer(); ?>
