<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin');
require_perm('permission_profiles','edit'); // admin module

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

$modules = [
  ['key'=>'dashboard', 'label'=>'Dashboard'],
  ['key'=>'banks', 'label'=>'Bancos'],
  ['key'=>'parties', 'label'=>'Clientes/Fornecedores'],
  ['key'=>'parties_import', 'label'=>'Importar CSV'],
  ['key'=>'contas_pagar', 'label'=>'Contas a Pagar'],
  ['key'=>'contas_receber', 'label'=>'Contas a Receber'],
  ['key'=>'categories', 'label'=>'Categorias'],
  ['key'=>'cost_centers', 'label'=>'Centros de Custo'],
  ['key'=>'accounts', 'label'=>'Plano de Contas'],
  ['key'=>'dre', 'label'=>'DRE'],
  ['key'=>'reconcile', 'label'=>'Conciliação'],
  ['key'=>'assistant_ai', 'label'=>'Assistente IA'],
  ['key'=>'prompt_categories', 'label'=>'Categorias Prompt'],
  ['key'=>'prompts', 'label'=>'Prompts'],
  ['key'=>'ia_settings', 'label'=>'Config IA (APIs)'],
  ['key'=>'settings', 'label'=>'Configurações (branding/SMTP)'],
  ['key'=>'audit_logs', 'label'=>'Auditoria'],
  ['key'=>'users', 'label'=>'Usuários'],
];

function profile_perms(PDO $pdo, int $pid): array {
  $st = $pdo->prepare("SELECT perm_key, can_view, can_create, can_edit, can_delete FROM profile_permissions WHERE profile_id=?");
  $st->execute([$pid]);
  $m = [];
  foreach ($st->fetchAll() as $r) {
    $m[$r['perm_key']] = [
      'view'=>(int)$r['can_view']===1,
      'create'=>(int)$r['can_create']===1,
      'edit'=>(int)$r['can_edit']===1,
      'delete'=>(int)$r['can_delete']===1,
    ];
  }
  return $m;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if ($action === 'create') {
      $name = trim($_POST['name'] ?? '');
      if ($name==='') throw new Exception('Informe o nome do perfil.');
      $pdo->prepare("INSERT INTO permission_profiles (name) VALUES (?)")->execute([$name]);
      audit_log('create','perm_profile',$pdo->lastInsertId(),['name'=>$name]);
      redirect('/permission_profiles.php?msg=Perfil criado');
    }

    if ($action === 'edit') {
      $pid = (int)($_POST['id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $is_active = (int)($_POST['is_active'] ?? 1);
      if ($pid<=0) throw new Exception('ID inválido.');
      if ($name==='') throw new Exception('Informe o nome.');

      $pdo->beginTransaction();
      $pdo->prepare("UPDATE permission_profiles SET name=?, is_active=?, updated_at=NOW() WHERE id=?")->execute([$name,$is_active,$pid]);

      // replace permissions
      $pdo->prepare("DELETE FROM profile_permissions WHERE profile_id=?")->execute([$pid]);
      $ins = $pdo->prepare("INSERT INTO profile_permissions (profile_id, perm_key, can_view, can_create, can_edit, can_delete) VALUES (?,?,?,?,?,?)");

      foreach ($modules as $m) {
        $k = $m['key'];
        $v = isset($_POST["p_{$k}_v"]) ? 1 : 0;
        $c = isset($_POST["p_{$k}_c"]) ? 1 : 0;
        $e = isset($_POST["p_{$k}_e"]) ? 1 : 0;
        $d = isset($_POST["p_{$k}_d"]) ? 1 : 0;
        if ($v===0) { $c=0; $e=0; $d=0; }
        $ins->execute([$pid,$k,$v,$c,$e,$d]);
      }

      $pdo->commit();
      perm_history_log('profile', $pid, 'manual', ['profile_id'=>$pid,'name'=>$name,'perms'=>$_POST]);
      audit_log('edit','perm_profile',$pid,['name'=>$name]);
      redirect('/permission_profiles.php?msg=Perfil atualizado');
    }
  } catch(Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    $err = $e->getMessage();
  }
}


if ($action === 'clone') {
  $id = (int)($_GET['id'] ?? 0);
  $st = $pdo->prepare("SELECT * FROM permission_profiles WHERE id=?");
  $st->execute([$id]);
  $orig = $st->fetch();
  if (!$orig) { redirect('/permission_profiles.php?msg=Perfil não encontrado'); }

  $newName = $orig['name'].' (Cópia '.date('d-m H:i').')';

  $pdo->beginTransaction();
  $pdo->prepare("INSERT INTO permission_profiles (name,is_active) VALUES (?,1)")->execute([$newName]);
  $newId = (int)$pdo->lastInsertId();

  $stp = $pdo->prepare("SELECT perm_key, can_view, can_create, can_edit, can_delete FROM profile_permissions WHERE profile_id=?");
  $stp->execute([$id]);
  $ins = $pdo->prepare("INSERT INTO profile_permissions (profile_id, perm_key, can_view, can_create, can_edit, can_delete) VALUES (?,?,?,?,?,?)");
  foreach ($stp->fetchAll() as $r) {
    $ins->execute([$newId,$r['perm_key'],(int)$r['can_view'],(int)$r['can_create'],(int)$r['can_edit'],(int)$r['can_delete']]);
  }
  $pdo->commit();

  perm_history_log('profile', $newId, 'clone', ['from'=>$id,'name'=>$newName]);
  audit_log('clone','perm_profile',$newId,['from'=>$id,'name'=>$newName]);

  redirect('/permission_profiles.php?msg=Perfil clonado');
}

render_header('Perfis de acesso');

if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if ($action === 'new') { ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Novo perfil</h3>
    <a class="btn btn-secondary" href="permission_profiles.php">Voltar</a>
  </div>

  <form method="post" action="permission_profiles.php?action=create" class="card shadow-sm p-3" style="max-width:820px">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <label class="form-label">Nome do perfil</label>
    <input class="form-control" name="name" required>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Criar</button>
      <a class="btn btn-secondary" href="permission_profiles.php">Cancelar</a>
    </div>
  </form>

<?php render_footer(); exit; }

if ($action === 'editform') {
  $pid = (int)($_GET['id'] ?? 0);
  $st = $pdo->prepare("SELECT * FROM permission_profiles WHERE id=?");
  $st->execute([$pid]);
  $prof = $st->fetch();
  if (!$prof) { echo '<div class="alert alert-danger">Perfil não encontrado.</div>'; render_footer(); exit; }

  $perms = profile_perms($pdo, $pid);
?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Editar perfil</h3>
    <a class="btn btn-secondary" href="permission_profiles.php">Voltar</a>
  </div>

  <form method="post" action="permission_profiles.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$prof['id'])?>">

    <div class="row g-3">
      <div class="col-md-8">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?=h($prof['name'])?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Ativo?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=(int)$prof['is_active']===1?'selected':''?>>Sim</option>
          <option value="0" <?=(int)$prof['is_active']===0?'selected':''?>>Não</option>
        </select>
      </div>
    </div>

    <hr class="my-4">

    <h5 class="mb-2">Permissões do perfil</h5>
    <div class="table-responsive">
      <table class="table table-sm table-striped align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th>Módulo</th>
            <th class="text-center">Ver</th>
            <th class="text-center">Incluir</th>
            <th class="text-center">Editar</th>
            <th class="text-center">Excluir</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($modules as $m):
            $k = $m['key'];
            $p = $perms[$k] ?? ['view'=>false,'create'=>false,'edit'=>false,'delete'=>false];
          ?>
            <tr>
              <td><?=h($m['label'])?></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_v" <?=$p['view']?'checked':''?>></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_c" <?=$p['create']?'checked':''?>></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_e" <?=$p['edit']?'checked':''?>></td>
              <td class="text-center"><input type="checkbox" name="p_<?=$k?>_d" <?=$p['delete']?'checked':''?>></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="permission_profiles.php">Cancelar</a>
    </div>
  </form>

<?php render_footer(); exit; }

$rows = $pdo->query("SELECT * FROM permission_profiles ORDER BY name")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Perfis de acesso</h3>
  <a class="btn btn-primary" href="permission_profiles.php?action=new">+ Novo</a>
</div>

<div class="row g-3">
  <?php foreach ($rows as $r): ?>
    <div class="col-md-4">
      <div class="list-card" data-tilt>
        <div class="d-flex justify-content-between align-items-start gap-2">
          <div>
            <div class="list-title"><?=h($r['name'])?></div>
            <div class="list-sub">Perfil</div>
          </div>
          <div><?= ((int)$r['is_active']===1) ? '<span class="badge bg-success glow-badge">Ativo</span>' : '<span class="badge bg-secondary">Inativo</span>' ?></div>
        </div>
        <div class="list-actions">
          <a class="btn btn-sm btn-outline-primary" href="permission_profiles.php?action=editform&id=<?=$r['id']?>">Editar</a>
          <a class="btn btn-sm btn-outline-dark" href="permission_profiles.php?action=clone&id=<?=$r['id']?>" onclick="return confirm('Clonar perfil?');">Clonar</a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
  <?php if (!$rows): ?><div class="col-12"><div class="alert alert-warning mb-0">Nenhum perfil.</div></div><?php endif; ?>
</div>

<?php render_footer(); ?>
