<?php
require __DIR__ . '/_init.php';
require_login();
require_perm('parties_import','create');

$pdo = db();
$msg = $_GET['msg'] ?? '';
$err = '';

/**
 * CSV esperado (com ou sem header):
 * party_type,name,doc,email,phone,notes,zip_code,address,address_number,district,city,state,country
 * party_type: CLIENTE|FORNECEDOR|AMBOS
 */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if (empty($_FILES['csv']) || $_FILES['csv']['error'] !== UPLOAD_ERR_OK) throw new Exception('Envie um CSV válido.');

    $fh = fopen($_FILES['csv']['tmp_name'], 'r');
    if (!$fh) throw new Exception('Não foi possível ler o CSV.');

    $first = fgetcsv($fh, 0, ',');
    if (!$first) throw new Exception('CSV vazio.');

    $header = array_map('strtolower', $first);
    $hasHeader = in_array('name', $header, true) || in_array('party_type', $header, true);

    $rows = [];
    if (!$hasHeader) $rows[] = $first;
    while (($r = fgetcsv($fh, 0, ',')) !== false) $rows[] = $r;
    fclose($fh);

    $ins = $pdo->prepare("
      INSERT INTO fin_parties (party_type, name, doc, email, phone, zip_code, address, address_number, district, city, state, country, notes, is_active)
      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,1)
    ");

    $count = 0;
    foreach ($rows as $r) {
      if ($hasHeader) {
        // map by header
        $map = [];
        for ($i=0; $i<count($header); $i++) $map[$header[$i]] = $r[$i] ?? '';
        $party_type = strtoupper(trim($map['party_type'] ?? 'AMBOS'));
        $name = trim($map['name'] ?? '');
        $doc = trim($map['doc'] ?? '');
        $email = trim($map['email'] ?? '');
        $phone = trim($map['phone'] ?? '');
        $notes = trim($map['notes'] ?? '');
        $zip = trim($map['zip_code'] ?? '');
        $address = trim($map['address'] ?? '');
        $num = trim($map['address_number'] ?? '');
        $district = trim($map['district'] ?? '');
        $city = trim($map['city'] ?? '');
        $state = trim($map['state'] ?? '');
        $country = trim($map['country'] ?? '');
      } else {
        // positional
        $party_type = strtoupper(trim($r[0] ?? 'AMBOS'));
        $name = trim($r[1] ?? '');
        $doc = trim($r[2] ?? '');
        $email = trim($r[3] ?? '');
        $phone = trim($r[4] ?? '');
        $notes = trim($r[5] ?? '');
        $zip = trim($r[6] ?? '');
        $address = trim($r[7] ?? '');
        $num = trim($r[8] ?? '');
        $district = trim($r[9] ?? '');
        $city = trim($r[10] ?? '');
        $state = trim($r[11] ?? '');
        $country = trim($r[12] ?? '');
      }

      if (!in_array($party_type, ['CLIENTE','FORNECEDOR','AMBOS'], true)) $party_type = 'AMBOS';
      if ($name === '') continue;

      $ins->execute([
        $party_type,
        $name,
        $doc !== '' ? $doc : null,
        $email !== '' ? $email : null,
        $phone !== '' ? $phone : null,
        $zip !== '' ? $zip : null,
        $address !== '' ? $address : null,
        $num !== '' ? $num : null,
        $district !== '' ? $district : null,
        $city !== '' ? $city : null,
        $state !== '' ? $state : null,
        $country !== '' ? $country : null,
        $notes !== '' ? $notes : null,
      ]);
      $count++;
    }

    redirect('/parties_import.php?msg=Importados: '.$count);
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

render_header('Importar Clientes/Fornecedores');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Importar por CSV</h3>
  <a class="btn btn-secondary" href="parties.php">Voltar</a>
</div>

<div class="card shadow-sm p-3 mb-3">
  <div class="text-muted">
    Formato do CSV (com ou sem header):
    <code>party_type,name,doc,email,phone,notes,zip_code,address,address_number,district,city,state,country</code>
  </div>
  <div class="text-muted mt-2">
    party_type: <b>CLIENTE</b> | <b>FORNECEDOR</b> | <b>AMBOS</b>
  </div>
</div>

<form method="post" enctype="multipart/form-data" class="card shadow-sm p-3" style="max-width:820px">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <div class="row g-3 align-items-end">
    <div class="col-md-8">
      <label class="form-label">Arquivo CSV</label>
      <input class="form-control" type="file" name="csv" accept=".csv,text/csv" required>
    </div>
    <div class="col-md-4 d-grid">
      <button class="btn btn-primary">Importar</button>
    </div>
  </div>
</form>

<?php render_footer(); ?>
