<?php
require __DIR__ . '/_init.php';
require_login();
require_perm('parties','view');

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

$typeFilter = $_GET['type'] ?? 'TODOS';
$q = trim($_GET['q'] ?? '');

$validTypes = ['CLIENTE','FORNECEDOR','AMBOS','TODOS'];
if (!in_array($typeFilter, $validTypes, true)) $typeFilter = 'TODOS';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if ($action === 'create') { require_perm('parties','create');
      $party_type = $_POST['party_type'] ?? 'AMBOS';
      if (!in_array($party_type, ['CLIENTE','FORNECEDOR','AMBOS'], true)) $party_type = 'AMBOS';

      $name = trim($_POST['name'] ?? '');
      $doc = trim($_POST['doc'] ?? '');
      $email = trim($_POST['email'] ?? '');
      $phone = trim($_POST['phone'] ?? '');
      $zip_code = trim($_POST['zip_code'] ?? '');
      $address = trim($_POST['address'] ?? '');
      $address_number = trim($_POST['address_number'] ?? '');
      $district = trim($_POST['district'] ?? '');
      $city = trim($_POST['city'] ?? '');
      $state = trim($_POST['state'] ?? '');
      $country = trim($_POST['country'] ?? '');
      $notes = trim($_POST['notes'] ?? '');

      if ($name === '') throw new Exception('Informe o nome.');

      $pdo->prepare("
        INSERT INTO fin_parties (party_type, name, doc, email, phone, notes)
        VALUES (?,?,?,?,?,?)
      ")->execute([
        $party_type,
        $name,
        $doc !== '' ? $doc : null,
        $email !== '' ? $email : null,
        $phone !== '' ? $phone : null,
        $notes !== '' ? $notes : null,
      ]);

      audit_log('create','party',$pdo->lastInsertId(),['name'=>$name,'type'=>$party_type]);
      redirect('/parties.php?msg=Cadastrado com sucesso');
    }

    if ($action === 'edit') { require_perm('parties','edit');
      $id = (int)($_POST['id'] ?? 0);
      $party_type = $_POST['party_type'] ?? 'AMBOS';
      if (!in_array($party_type, ['CLIENTE','FORNECEDOR','AMBOS'], true)) $party_type = 'AMBOS';

      $name = trim($_POST['name'] ?? '');
      $doc = trim($_POST['doc'] ?? '');
      $email = trim($_POST['email'] ?? '');
      $phone = trim($_POST['phone'] ?? '');
      $zip_code = trim($_POST['zip_code'] ?? '');
      $address = trim($_POST['address'] ?? '');
      $address_number = trim($_POST['address_number'] ?? '');
      $district = trim($_POST['district'] ?? '');
      $city = trim($_POST['city'] ?? '');
      $state = trim($_POST['state'] ?? '');
      $country = trim($_POST['country'] ?? '');
      $notes = trim($_POST['notes'] ?? '');
      $is_active = (int)($_POST['is_active'] ?? 1);

      if ($name === '') throw new Exception('Informe o nome.');

      $pdo->prepare("
        UPDATE fin_parties
        SET party_type=?, name=?, doc=?, email=?, phone=?, zip_code=?, address=?, address_number=?, district=?, city=?, state=?, country=?, notes=?, is_active=?, updated_at=NOW()
        WHERE id=?
      ")->execute([
        $party_type,
        $name,
        $doc !== '' ? $doc : null,
        $email !== '' ? $email : null,
        $phone !== '' ? $phone : null,
        $zip_code !== '' ? $zip_code : null,
        $address !== '' ? $address : null,
        $address_number !== '' ? $address_number : null,
        $district !== '' ? $district : null,
        $city !== '' ? $city : null,
        $state !== '' ? $state : null,
        $country !== '' ? $country : null,
        $notes !== '' ? $notes : null,
        $is_active,
        $id
      ]);

      audit_log('edit','party',$id,[]);
      redirect('/parties.php?msg=Atualizado');
    }
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

render_header('Clientes / Fornecedores');

if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

if ($action === 'new') {
  $pref = $_GET['pref'] ?? 'AMBOS';
  if (!in_array($pref, ['CLIENTE','FORNECEDOR','AMBOS'], true)) $pref = 'AMBOS';
  ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Novo cadastro</h3>
    
  <div class="listview-toggle">
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="grid" title="Grade"><i class="bi bi-grid-3x3-gap"></i></button>
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="compact" title="Compacto"><i class="bi bi-list"></i></button>
  </div>
<a class="btn btn-secondary" href="parties.php">Voltar</a>
  </div>

  <form method="post" action="parties.php?action=create" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row g-3">
      <div class="col-md-3">
        <label class="form-label">Tipo</label>
        <select class="form-select" name="party_type">
          <option value="CLIENTE" <?=$pref==='CLIENTE'?'selected':''?>>Cliente</option>
          <option value="FORNECEDOR" <?=$pref==='FORNECEDOR'?'selected':''?>>Fornecedor</option>
          <option value="AMBOS" <?=$pref==='AMBOS'?'selected':''?>>Ambos</option>
        </select>
      </div>
      <div class="col-md-5">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">CPF/CNPJ (opcional)</label>
        <input class="form-control" name="doc">
      </div>
      <div class="col-md-4">
        <label class="form-label">E-mail (opcional)</label>
        <input class="form-control" name="email" type="email">
      </div>
      <div class="col-md-4">
        <label class="form-label">Telefone (opcional)</label>
        <input class="form-control" name="phone">
      </div>
      <div class="col-md-3">
        <label class="form-label">CEP (opcional)</label>
        <input class="form-control" name="zip_code">
      </div>
      <div class="col-md-6">
        <label class="form-label">Endereço (opcional)</label>
        <input class="form-control" name="address" placeholder="Rua, Av...">
      </div>
      <div class="col-md-3">
        <label class="form-label">Número</label>
        <input class="form-control" name="address_number">
      </div>
      <div class="col-md-4">
        <label class="form-label">Bairro</label>
        <input class="form-control" name="district">
      </div>
      <div class="col-md-4">
        <label class="form-label">Cidade</label>
        <input class="form-control" name="city">
      </div>
      <div class="col-md-2">
        <label class="form-label">UF</label>
        <input class="form-control" name="state">
      </div>
      <div class="col-md-2">
        <label class="form-label">País</label>
        <input class="form-control" name="country" value="Brasil">
      </div>
      <div class="col-md-4">
        <label class="form-label">Obs (opcional)</label>
        <input class="form-control" name="notes">
      </div>
    </div>

    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="parties.php">Cancelar</a>
    </div>
  </form>
  <?php
  render_footer();
  exit;
}

if ($action === 'editform') {
  $id = (int)($_GET['id'] ?? 0);
  $rangeDays = (int)($_GET['range'] ?? 30);
  if (!in_array($rangeDays, [5,30,60,90], true)) $rangeDays = 30;
  $rangeStart = (new DateTime('now'))->modify('-'.$rangeDays.' days')->format('Y-m-d 00:00:00');
  $rangeEnd = (new DateTime('now'))->format('Y-m-d 23:59:59');
  $st = $pdo->prepare("SELECT * FROM fin_parties WHERE id=?");
  $st->execute([$id]);
  $p = $st->fetch();
  if (!$p) { echo '<div class="alert alert-danger">Cadastro não encontrado.</div>'; render_footer(); exit; }
  ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Editar cadastro</h3>
    <a class="btn btn-outline-dark" href="parties.php?action=view&id=<?=$p['id']?>">Ver</a>
    <a class="btn btn-secondary" href="parties.php">Voltar</a>
  </div>

  <form method="post" action="parties.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$p['id'])?>">
    <div class="row g-3">
      <div class="col-md-3">
        <label class="form-label">Tipo</label>
        <select class="form-select" name="party_type">
          <option value="CLIENTE" <?=$p['party_type']==='CLIENTE'?'selected':''?>>Cliente</option>
          <option value="FORNECEDOR" <?=$p['party_type']==='FORNECEDOR'?'selected':''?>>Fornecedor</option>
          <option value="AMBOS" <?=$p['party_type']==='AMBOS'?'selected':''?>>Ambos</option>
        </select>
      </div>
      <div class="col-md-5">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?=h($p['name'])?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">CPF/CNPJ</label>
        <input class="form-control" name="doc" value="<?=h((string)($p['doc'] ?? ''))?>">
      </div>

      <div class="col-md-4">
        <label class="form-label">E-mail</label>
        <input class="form-control" name="email" type="email" value="<?=h((string)($p['email'] ?? ''))?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Telefone</label>
        <input class="form-control" name="phone" value="<?=h((string)($p['phone'] ?? ''))?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Ativo?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=((int)$p['is_active']===1)?'selected':''?>>Sim</option>
          <option value="0" <?=((int)$p['is_active']===0)?'selected':''?>>Não</option>
        </select>
      </div>
      <div class="col-md-12">
        <label class="form-label">Obs</label>
        <input class="form-control" name="notes" value="<?=h((string)($p['notes'] ?? ''))?>">
      </div>
    </div>

    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="parties.php">Cancelar</a>
    </div>
  </form>
  <?php
  render_footer();
  exit;
}


if ($action === 'view') {
  $id = (int)($_GET['id'] ?? 0);
  $rangeDays = (int)($_GET['range'] ?? 30);
  if (!in_array($rangeDays, [5,30,60,90], true)) $rangeDays = 30;
  $rangeStart = (new DateTime('now'))->modify('-'.$rangeDays.' days')->format('Y-m-d 00:00:00');
  $rangeEnd = (new DateTime('now'))->format('Y-m-d 23:59:59');
  $st = $pdo->prepare("SELECT * FROM fin_parties WHERE id=?");
  $st->execute([$id]);
  $p = $st->fetch();
  if (!$p) { echo '<div class="alert alert-danger">Cadastro não encontrado.</div>'; render_footer(); exit; }

  // Estatísticas (vínculos no financeiro)
  $stx = $pdo->prepare("
    SELECT
      COALESCE(SUM(d.doc_type='PAGAR'),0) AS docs_pagar,
      COALESCE(SUM(d.doc_type='RECEBER'),0) AS docs_receber,
      COALESCE(SUM(i.status IN ('ABERTO','PARCIAL') AND d.doc_type='PAGAR'),0) AS inst_open_pagar,
      COALESCE(SUM(i.status IN ('ABERTO','PARCIAL') AND d.doc_type='RECEBER'),0) AS inst_open_receber,
      COALESCE(SUM(CASE WHEN d.doc_type='PAGAR' AND i.status IN ('ABERTO','PARCIAL') THEN (i.amount - i.paid_amount) ELSE 0 END),0) AS aberto_pagar,
      COALESCE(SUM(CASE WHEN d.doc_type='RECEBER' AND i.status IN ('ABERTO','PARCIAL') THEN (i.amount - i.paid_amount) ELSE 0 END),0) AS aberto_receber
    FROM fin_documents d
    LEFT JOIN fin_installments i ON i.document_id=d.id
    WHERE d.counterparty_id=?
  ");
  $stx->execute([(int)$p['id']]);
  $stats = $stx->fetch() ?: [
    'docs_pagar'=>0,'docs_receber'=>0,'inst_open_pagar'=>0,'inst_open_receber'=>0,'aberto_pagar'=>0,'aberto_receber'=>0
  ];


  // Últimas movimentações (baixas) desse cadastro
  $stm = $pdo->prepare("
    SELECT
      s.occurred_at,
      d.doc_type,
      d.description,
      i.installment_no,
      s.amount,
      s.direction,
      b.bank_name,
      b.bank_number,
      s.note
    FROM fin_settlements s
    JOIN fin_installments i ON i.id = s.installment_id
    JOIN fin_documents d ON d.id = i.document_id
    JOIN banks b ON b.id = s.bank_id
    WHERE d.counterparty_id = ? AND s.reversed_at IS NULL
      AND s.occurred_at BETWEEN ? AND ?
    ORDER BY s.occurred_at DESC
    LIMIT 200
  ");
  $stm->execute([(int)$p['id'], $rangeStart, $rangeEnd]);
  $movs = $stm->fetchAll();
  // Sparkline (total diário de baixas no período, valor absoluto)
  $sts = $pdo->prepare("
    SELECT DATE(s.occurred_at) AS d,
      COALESCE(SUM(CASE WHEN d2.doc_type='RECEBER' THEN s.amount ELSE 0 END),0) AS recv,
      COALESCE(SUM(CASE WHEN d2.doc_type='PAGAR' THEN s.amount ELSE 0 END),0) AS pay
    FROM fin_settlements s
    JOIN fin_installments i2 ON i2.id = s.installment_id
    JOIN fin_documents d2 ON d2.id = i2.document_id
    WHERE d2.counterparty_id = ? AND s.reversed_at IS NULL
      AND s.occurred_at BETWEEN ? AND ?
    GROUP BY DATE(s.occurred_at)
    ORDER BY d
  ");
  $sts->execute([(int)$p['id'], $rangeStart, $rangeEnd]);
  $rowsSpark = $sts->fetchAll();

  $mapS = [];
  foreach($rowsSpark as $rr){ $mapS[$rr['d']] = ['r'=>(float)$rr['recv'], 'p'=>(float)$rr['pay']]; }

  $d0 = new DateTime(substr($rangeStart,0,10));
  $d1 = new DateTime(substr($rangeEnd,0,10));
  $valsRecv = [];
  $valsPay = [];
  $cur = clone $d0;
  while($cur <= $d1){
    $k = $cur->format('Y-m-d');
    $valsRecv[] = $mapS[$k]['r'] ?? 0.0;
    $valsPay[]  = $mapS[$k]['p'] ?? 0.0;
    $cur->modify('+1 day');
  }

  $w=220; $h=46; $pad=5;
  $sparkPointsRecv = '';
  $sparkPointsPay = '';
  $n=count($valsRecv);
  if($n>1){
    $minR=min($valsRecv); $maxR=max($valsRecv);
    $minP=min($valsPay);  $maxP=max($valsPay);
    if(abs($maxR-$minR)<0.00001){ $maxR=$minR+1.0; }
    if(abs($maxP-$minP)<0.00001){ $maxP=$minP+1.0; }
    $dx = ($w-2*$pad)/($n-1);

    $ptsR=[]; $ptsP=[];
    for($i=0;$i<$n;$i++){
      $x = $pad + $dx*$i;

      $tR = ($valsRecv[$i]-$minR)/($maxR-$minR);
      $yR = ($h-$pad) - $tR*($h-2*$pad);
      $ptsR[] = round($x,2).','.round($yR,2);

      $tP = ($valsPay[$i]-$minP)/($maxP-$minP);
      $yP = ($h-$pad) - $tP*($h-2*$pad);
      $ptsP[] = round($x,2).','.round($yP,2);
    }
    $sparkPointsRecv = implode(' ', $ptsR);
    $sparkPointsPay  = implode(' ', $ptsP);
  }


  // Iniciais (avatar)
  $nameParts = preg_split('/\s+/', trim((string)$p['name']));
  $ini = '';
  if (!empty($nameParts[0])) $ini .= mb_strtoupper(mb_substr($nameParts[0],0,1,'UTF-8'),'UTF-8');
  if (count($nameParts) > 1 && !empty($nameParts[count($nameParts)-1])) $ini .= mb_strtoupper(mb_substr($nameParts[count($nameParts)-1],0,1,'UTF-8'),'UTF-8');

  ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Visualização</h3>
    <div class="d-flex flex-wrap gap-2">
      <?php if ($p['party_type']==='FORNECEDOR' || $p['party_type']==='AMBOS'): ?>
        <a class="btn btn-outline-light ripple-target" href="conta_form.php?type=PAGAR&party_id=<?=$p['id']?>"><i class="bi bi-plus-circle me-1"></i>Novo pagar</a>
      <?php endif; ?>
      <?php if ($p['party_type']==='CLIENTE' || $p['party_type']==='AMBOS'): ?>
        <a class="btn btn-outline-light ripple-target" href="conta_form.php?type=RECEBER&party_id=<?=$p['id']?>"><i class="bi bi-plus-circle me-1"></i>Novo receber</a>
      <?php endif; ?>
      <a class="btn btn-outline-dark ripple-target" href="party_pdf.php?id=<?=$p['id']?>&range=<?=$rangeDays?>" target="_blank"><i class="bi bi-file-earmark-pdf me-1"></i>PDF</a>
      <a class="btn btn-outline-primary" href="parties.php?action=editform&id=<?=$p['id']?>">Editar</a>
      <a class="btn btn-secondary" href="parties.php">Voltar</a>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-lg-5">
      <div class="list-card" data-tilt>
        <div class="d-flex justify-content-between align-items-start gap-2">
          <div>
            <div class="party-head">
            <div class="party-avatar" aria-hidden="true"><?=h($ini ?: '•')?></div>
            <div>
              <div class="list-title"><?=h($p['name'])?></div>
              
            </div>
          </div>
            <div class="list-sub"><?=h($p['party_type'])?><?= !empty($p['doc']) ? ' • '.h($p['doc']) : '' ?></div>
          </div>
          <div>
            <?= ((int)$p['is_active']===1) ? '<span class="badge bg-success glow-badge">Ativo</span>' : '<span class="badge bg-secondary">Inativo</span>' ?>
          </div>
        </div>

        <div class="party-stats">
          <span class="stat-chip"><span class="stat-lbl">Docs</span><span class="stat-val"><?=h((string)((int)$stats['docs_pagar'] + (int)$stats['docs_receber']))?></span></span>
          <span class="stat-chip"><span class="stat-lbl">Em aberto</span><span class="stat-val"><?=h(number_format(((float)$stats['aberto_pagar'] + (float)$stats['aberto_receber']),2,',','.'))?></span></span>
          <span class="stat-chip"><span class="stat-lbl">Pagar</span><span class="stat-val"><?=h(number_format((float)$stats['aberto_pagar'],2,',','.'))?></span></span>
          <span class="stat-chip"><span class="stat-lbl">Receber</span><span class="stat-val"><?=h(number_format((float)$stats['aberto_receber'],2,',','.'))?></span></span>
        </div>

        <div class="list-meta">
          <div class="meta-item">
            <div class="meta-label">E-mail</div>
            <div class="meta-value"><?=h((string)($p['email'] ?? '—'))?></div>
          </div>
          <div class="meta-item">
            <div class="meta-label">Telefone</div>
            <div class="meta-value"><?=h((string)($p['phone'] ?? '—'))?></div>
          </div>
          <div class="meta-item">
            <div class="meta-label">CEP</div>
            <div class="meta-value"><?=h((string)($p['zip_code'] ?? '—'))?></div>
          </div>
          <div class="meta-item">
            <div class="meta-label">Cidade/UF</div>
            <div class="meta-value"><?=h((string)($p['city'] ?? '—'))?> <?=h((string)($p['state'] ?? ''))?></div>
          </div>
        </div>

        <div class="meta-item mt-2">
          <div class="meta-label">Endereço</div>
          <div class="meta-value">
            <?=h((string)($p['address'] ?? '—'))?>
            <?= $p['address_number'] ? ' - '.h((string)$p['address_number']) : '' ?>
            <?= $p['district'] ? ' • '.h((string)$p['district']) : '' ?>
          </div>
        </div>

        <?php if (!empty($p['notes'])): ?>
          <div class="meta-item mt-2">
            <div class="meta-label">Obs</div>
            <div class="meta-value"><?=h((string)$p['notes'])?></div>
          </div>
        <?php endif; ?>

        <div class="list-actions">
          <?php if (perm_can('parties','edit')): ?>
<a class="btn btn-sm btn-outline-primary" href="parties.php?action=editform&id=<?=$p['id']?>">Editar</a>
<?php endif; ?>
          <a class="btn btn-sm btn-outline-dark" href="parties.php">Lista</a>
        </div>
      </div>
    </div>

    <div class="col-lg-7">
      <div class="card shadow-sm p-3">
        <h5 class="mb-2">Resumo rápido</h5>
<div class="d-flex flex-wrap gap-2 mb-3">
  <?php if ($p['party_type']==='FORNECEDOR' || $p['party_type']==='AMBOS'): ?>
    <a class="btn btn-sm btn-outline-primary ripple-target" href="conta_form.php?type=PAGAR&party_id=<?=$p['id']?>">+ Lançar pagar</a>
  <?php endif; ?>
  <?php if ($p['party_type']==='CLIENTE' || $p['party_type']==='AMBOS'): ?>
    <a class="btn btn-sm btn-outline-primary ripple-target" href="conta_form.php?type=RECEBER&party_id=<?=$p['id']?>">+ Lançar receber</a>
  <?php endif; ?>
</div>
<div class="row g-3 mb-2">
  <div class="col-md-6"><div class="meta-item"><div class="meta-label">Docs pagar</div><div class="meta-value"><?=h((string)$stats['docs_pagar'])?></div></div></div>
  <div class="col-md-6"><div class="meta-item"><div class="meta-label">Docs receber</div><div class="meta-value"><?=h((string)$stats['docs_receber'])?></div></div></div>
  <div class="col-md-6"><div class="meta-item"><div class="meta-label">Parcelas em aberto (pagar)</div><div class="meta-value"><?=h((string)$stats['inst_open_pagar'])?></div></div></div>
  <div class="col-md-6"><div class="meta-item"><div class="meta-label">Parcelas em aberto (receber)</div><div class="meta-value"><?=h((string)$stats['inst_open_receber'])?></div></div></div>
</div>
        <div class="text-muted">
          Use este cadastro ao criar lançamentos de <b><?=h($p['party_type']==='FORNECEDOR'?'Contas a Pagar':'Contas a Receber')?></b>.
        </div>
        <hr>
        <div class="row g-3">
          <div class="col-md-6">
            <div class="meta-item">
              <div class="meta-label">Tipo</div>
              <div class="meta-value"><?=h($p['party_type'])?></div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="meta-item">
              <div class="meta-label">Documento</div>
              <div class="meta-value"><?=h((string)($p['doc'] ?? '—'))?></div>
            </div>
          </div>
          <div class="col-md-12">
            <div class="meta-item">
              <div class="meta-label">Contato</div>
              <div class="meta-value">
                <?=h((string)($p['email'] ?? '—'))?> • <?=h((string)($p['phone'] ?? '—'))?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  render_footer();
  exit;
}


$where = [];
$params = [];

if ($typeFilter !== 'TODOS') {
  if ($typeFilter === 'CLIENTE') $where[] = "(party_type='CLIENTE' OR party_type='AMBOS')";
  elseif ($typeFilter === 'FORNECEDOR') $where[] = "(party_type='FORNECEDOR' OR party_type='AMBOS')";
  else $where[] = "party_type='AMBOS'";
}

if ($q !== '') {
  $where[] = "(name LIKE :q OR doc LIKE :q OR email LIKE :q OR phone LIKE :q)";
  $params[':q'] = "%{$q}%";
}

$sql = "SELECT * FROM fin_parties";
if ($where) $sql .= " WHERE ".implode(" AND ", $where);
$sql .= " ORDER BY name";

$st = $pdo->prepare($sql);
$st->execute($params);
$list = $st->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Clientes / Fornecedores</h3>
  <?php if (perm_can('parties','create')): ?>
<a class="btn btn-primary" href="parties.php?action=new">+ Novo</a>
<?php endif; ?>
</div>

<form class="row g-2 mb-3">
  <div class="col-md-3">
    <select class="form-select" name="type">
      <option value="TODOS" <?=$typeFilter==='TODOS'?'selected':''?>>Todos</option>
      <option value="CLIENTE" <?=$typeFilter==='CLIENTE'?'selected':''?>>Clientes</option>
      <option value="FORNECEDOR" <?=$typeFilter==='FORNECEDOR'?'selected':''?>>Fornecedores</option>
      <option value="AMBOS" <?=$typeFilter==='AMBOS'?'selected':''?>>Ambos</option>
    </select>
  </div>
  <div class="col-md-7">
    <input class="form-control" name="q" value="<?=h($q)?>" placeholder="Buscar por nome, doc, e-mail, telefone">
  </div>
  <div class="col-md-2 d-grid">
    <button class="btn btn-outline-dark">Filtrar</button>
  </div>
</form>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0 align-middle">
      <thead class="table-dark">
        <tr>
          <th>Nome</th>
          <th>Tipo</th>
          <th>Doc</th>
          <th>E-mail</th>
          <th>Telefone</th>
          <th>Cidade/UF</th>
          <th>Status</th>
          <th style="width:120px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($list as $p): ?>
          <tr>
            <td><?=h($p['name'])?></td>
            <td><?=h($p['party_type'])?></td>
            <td><?=h((string)($p['doc'] ?? ''))?></td>
            <td><?=h((string)($p['email'] ?? ''))?></td>
            <td><?=h((string)($p['phone'] ?? ''))?></td>
            <td><?=h((string)($p['city'] ?? ''))?> <?=h((string)($p['state'] ?? ''))?></td>
            <td><?= ((int)$p['is_active']===1) ? '<span class="badge bg-success glow-badge">Ativo</span>' : '<span class="badge bg-secondary">Inativo</span>' ?></td>
            <td class="text-end">
              <?php if (perm_can('parties','edit')): ?>
<a class="btn btn-sm btn-outline-primary" href="parties.php?action=editform&id=<?=$p['id']?>">Editar</a>
<?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$list): ?>
          <tr><td colspan="8" class="text-center text-muted py-4">Nenhum cadastro.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php render_footer(); ?>
