<?php
require __DIR__ . '/_init.php';
require_login();

$pdo = db();
$id = (int)($_GET['id'] ?? 0);

$stmt = $pdo->prepare("
  SELECT i.*, d.doc_type, d.counterparty_name, d.description AS doc_desc
  FROM fin_installments i
  JOIN fin_documents d ON d.id = i.document_id
  WHERE i.id=?
");
$stmt->execute([$id]);
$inst = $stmt->fetch();
$permKey = ($inst['doc_type']==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'edit');

if (!$inst) { render_header('Erro'); echo '<div class="alert alert-danger">Parcela não encontrada.</div>'; render_footer(); exit; }
$permKey = ($inst['doc_type']==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'edit');

$banks = $pdo->query("SELECT id, bank_name, bank_number, agency, account_type FROM banks ORDER BY bank_name")->fetchAll();

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if (isset($_POST['do_cancel'])) { require_perm($permKey,'delete');
      if ($inst['status'] === 'BAIXADO') throw new Exception('Não é possível cancelar parcela baixada. Estorne as baixas primeiro.');
      $pdo->prepare("UPDATE fin_installments SET status='CANCELADO', updated_at=NOW() WHERE id=?")->execute([$id]);
      redirect('/contas.php?type='.$inst['doc_type'].'&status=TODOS');
    }

    if ($inst['status'] === 'BAIXADO' || $inst['status'] === 'CANCELADO') throw new Exception('Parcela não editável nesse status.');

    $due_date = $_POST['due_date'] ?? $inst['due_date'];
    $amount = money_to_decimal($_POST['amount'] ?? (string)$inst['amount']);
    $bank_id = (int)($_POST['bank_id'] ?? 0);

    if ($bank_id <= 0) throw new Exception('Selecione um banco (obrigatório).');
    if ((float)$amount <= 0) throw new Exception('Valor inválido.');
    if ((float)$amount + 0.00001 < (float)$inst['paid_amount']) throw new Exception('Valor não pode ser menor que o já pago.');

    $pdo->prepare("
      UPDATE fin_installments
      SET due_date=?, amount=?, bank_id=?, updated_at=NOW()
      WHERE id=?
    ")->execute([$due_date, $amount, $bank_id, $id]);

    redirect('/contas.php?type='.$inst['doc_type'].'&status=TODOS');
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

render_header('Editar Parcela');
?>
<h3 class="mb-3">Editar Parcela</h3>

<div class="card shadow-sm p-3 mb-3">
  <div><span class="text-muted">Tipo:</span> <b><?=h($inst['doc_type'])?></b></div>
  <div><span class="text-muted">Pessoa:</span> <b><?=h($inst['counterparty_name'])?></b></div>
  <div><span class="text-muted">Descrição:</span> <b><?=h($inst['doc_desc'])?></b></div>
  <div><span class="text-muted">Parcela:</span> <b><?=h((string)$inst['installment_no'])?></b></div>
  <div><span class="text-muted">Status:</span> <b><?=h($inst['status'])?></b></div>
  <div><span class="text-muted">Pago:</span> <b>R$ <?=h(number_format((float)$inst['paid_amount'],2,',','.'))?></b></div>
</div>

<?php if ($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<form method="post" class="card shadow-sm p-3">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <div class="row g-3">
    <div class="col-md-3">
      <label class="form-label">Vencimento</label>
      <input class="form-control" type="date" name="due_date" value="<?=h($inst['due_date'])?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">Valor</label>
      <input class="form-control" name="amount" value="<?=h(number_format((float)$inst['amount'],2,',','.'))?>" data-money="brl">
      <div class="form-text">Não pode ser menor que o pago.</div>
    </div>
    <div class="col-md-6">
      <label class="form-label">Banco (obrigatório)</label>
      <select class="form-select" name="bank_id">
        <?php foreach ($banks as $b): ?>
          <option value="<?=$b['id']?>" <?=$b['id']==$inst['bank_id']?'selected':''?>>
            <?=h($b['bank_name'].' ('.$b['bank_number'].') Ag '.$b['agency'].' '.$b['account_type'])?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>

  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-primary">Salvar</button>
    <a class="btn btn-secondary" href="contas.php?type=<?=$inst['doc_type']?>">Voltar</a>

    <button class="btn btn-outline-danger ms-auto" name="do_cancel" value="1"
      onclick="return confirm('Cancelar esta parcela?');">
      Excluir (Cancelar)
    </button>
  </div>
</form>

<?php render_footer(); ?>
