<?php
require __DIR__.'/_init.php';
require_login();

$pdo = db();

/**
 * MariaDB/MySQL: comandos SHOW (ex.: SHOW TABLES LIKE ?) não aceitam placeholders em prepared statements
 * em algumas versões. Usamos information_schema (seguro).
 */
function table_exists(PDO $pdo, string $t): bool {
  $st = $pdo->prepare("SELECT 1 FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = ? LIMIT 1");
  $st->execute([$t]);
  return (bool)$st->fetchColumn();
}

function col_exists(PDO $pdo, string $t, string $c): bool {
  $st = $pdo->prepare("SELECT 1 FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = ? AND column_name = ? LIMIT 1");
  $st->execute([$t, $c]);
  return (bool)$st->fetchColumn();
}

$checks = [
  ['table','user_permissions'],
  ['table','permission_profiles'],
  ['table','profile_permissions'],
  ['table','perm_history'],
  ['table','audit_logs'],
  ['table','prompt_categories'],
  ['table','prompts'],
  ['table','ai_reports'],
  ['col','users','profile_id'],
  ['col','ai_reports','prompt_id'],
];

$results = [];
foreach ($checks as $c) {
  if ($c[0]==='table') $results[] = [$c[1], table_exists($pdo,$c[1])];
  else $results[] = [$c[1].'.'.$c[2], table_exists($pdo,$c[1]) ? col_exists($pdo,$c[1],$c[2]) : false];
}

render_header('Diagnóstico');
?>
<h3 class="mb-3">Diagnóstico (Admin/IA)</h3>

<div class="card shadow-sm p-3 mb-3">
  <div><b>Usuário:</b> <?=h($_SESSION['user_name'] ?? '')?> (ID <?=h((string)($_SESSION['user_id'] ?? ''))?>)</div>
  <div><b>Role:</b> <?=h($_SESSION['user_role'] ?? '')?></div>
  <div><b>Perms carregadas:</b> <?=h(json_encode($_SESSION['perms'] ?? [], JSON_UNESCAPED_UNICODE))?></div>
</div>

<div class="card shadow-sm p-3">
  <h5 class="mb-2">Estrutura do banco</h5>
  <div class="table-responsive">
    <table class="table table-sm table-striped mb-0">
      <thead class="table-dark"><tr><th>Item</th><th>Status</th></tr></thead>
      <tbody>
        <?php foreach($results as [$k,$ok]): ?>
          <tr>
            <td><?=h($k)?></td>
            <td><?= $ok ? '<span class="badge bg-success glow-badge">OK</span>' : '<span class="badge bg-danger">FALTANDO</span>' ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="text-muted small mt-2">
    Se algo estiver faltando, rode as migrations do projeto.
  </div>
</div>

<?php render_footer(); ?>
