<?php
require __DIR__ . '/_init.php';
require_login();

$pdo = db();
$type = $_GET['type'] ?? 'PAGAR';
if (!in_array($type, ['PAGAR','RECEBER'], true)) $type = 'PAGAR';
$permKey = ($type==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'create');

// Lista de clientes/fornecedores para seleção
$prefPartyId = (int)($_GET['party_id'] ?? 0);
$partyWhere = ($type==='PAGAR') ? "(party_type='FORNECEDOR' OR party_type='AMBOS')" : "(party_type='CLIENTE' OR party_type='AMBOS')";
$parties = $pdo->query("SELECT id, name, party_type FROM fin_parties WHERE is_active=1 AND {$partyWhere} ORDER BY name")->fetchAll();
if ($prefPartyId>0) {
  $found = false;
  foreach ($parties as $ppp) { if ((int)$ppp['id'] === $prefPartyId) { $found = true; break; } }
  if (!$found) {
    $stPref = $pdo->prepare("SELECT id, name, party_type FROM fin_parties WHERE id=? AND is_active=1 LIMIT 1");
    $stPref->execute([$prefPartyId]);
    $prefRow = $stPref->fetch();
    if ($prefRow) array_unshift($parties, $prefRow);
  }
}


$banks = $pdo->query("SELECT id, bank_name, bank_number, agency, account_type FROM banks ORDER BY bank_name")->fetchAll();
$cats  = $pdo->query("SELECT id, name, type FROM fin_categories WHERE is_active=1 ORDER BY name")->fetchAll();
$ccs   = $pdo->query("SELECT id, name FROM fin_cost_centers WHERE is_active=1 ORDER BY name")->fetchAll();
$accs  = $pdo->query("SELECT id, code, name, type FROM fin_accounts WHERE is_active=1 ORDER BY code")->fetchAll();

if (!$banks) {
  render_header('Aviso');
  echo '<div class="alert alert-warning">Cadastre um banco antes de criar lançamentos.</div>';
  echo '<a class="btn btn-primary" href="banks.php?action=new">Cadastrar banco</a>';
  render_footer();
  exit;
}

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    $doc_type = $_POST['doc_type'] ?? $type;
    $counterparty_name = trim($_POST['counterparty_name'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $issue_date = $_POST['issue_date'] ?? date('Y-m-d');
    $total_amount = money_to_decimal($_POST['total_amount'] ?? '0');
    $installments_count = (int)($_POST['installments_count'] ?? 1);
    $first_due_date = $_POST['first_due_date'] ?? date('Y-m-d');
    $default_bank_id = (int)($_POST['default_bank_id'] ?? 0);

    $category_id = (int)($_POST['category_id'] ?? 0);
    $cost_center_id = (int)($_POST['cost_center_id'] ?? 0);
    $account_id = (int)($_POST['account_id'] ?? 0);
    $doc_number = trim($_POST['doc_number'] ?? '');
    $notes = trim($_POST['notes'] ?? '');

    if ($counterparty_name==='' || $description==='') throw new Exception('Preencha cliente/fornecedor e descrição.');
    if ($installments_count < 1 || $installments_count > 120) throw new Exception('Parcelas inválidas (1 a 120).');
    if ($default_bank_id <= 0) throw new Exception('Selecione um banco (obrigatório).');
    if ((float)$total_amount <= 0) throw new Exception('Valor total inválido.');

    $pdo->beginTransaction();

    $stmt = $pdo->prepare("
      INSERT INTO fin_documents
        (doc_type, counterparty_name, description, category_id, cost_center_id, account_id, doc_number, notes,
         issue_date, total_amount, installments_count, default_bank_id)
      VALUES
        (:doc_type, :counterparty_name, :description, :category_id, :cost_center_id, :account_id, :doc_number, :notes,
         :issue_date, :total_amount, :installments_count, :default_bank_id)
    ");
    $stmt->execute([
      ':doc_type' => $doc_type,
      ':counterparty_name' => $counterparty_name,
      ':description' => $description,
      ':category_id' => $category_id > 0 ? $category_id : null,
      ':cost_center_id' => $cost_center_id > 0 ? $cost_center_id : null,
      ':account_id' => $account_id > 0 ? $account_id : null,
      ':doc_number' => $doc_number !== '' ? $doc_number : null,
      ':notes' => $notes !== '' ? $notes : null,
      ':issue_date' => $issue_date,
      ':total_amount' => $total_amount,
      ':installments_count' => $installments_count,
      ':default_bank_id' => $default_bank_id,
    ]);
    $docId = (int)$pdo->lastInsertId();

    $amounts = split_installments($total_amount, $installments_count);
    $due = new DateTime($first_due_date);

    $ins = $pdo->prepare("
      INSERT INTO fin_installments
        (document_id, installment_no, due_date, amount, bank_id)
      VALUES
        (:document_id, :installment_no, :due_date, :amount, :bank_id)
    ");

    for ($i=1; $i<=$installments_count; $i++) {
      $ins->execute([
        ':document_id' => $docId,
        ':installment_no' => $i,
        ':due_date' => $due->format('Y-m-d'),
        ':amount' => $amounts[$i-1],
        ':bank_id' => $default_bank_id,
      ]);
      $due->modify('+1 month');
    }

    $pdo->commit();
    redirect('/contas.php?type='.$doc_type.'&status=ABERTO');
  } catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    $err = $e->getMessage();
  }
}

render_header($type==='PAGAR' ? 'Novo - Contas a Pagar' : 'Novo - Contas a Receber');
?>
<h3 class="mb-3"><?=$type==='PAGAR'?'Novo lançamento a pagar':'Novo lançamento a receber'?></h3>

<?php if ($err): ?>
  <div class="alert alert-danger"><?=h($err)?></div>
<?php endif; ?>

<form method="post" class="card shadow-sm p-3">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <input type="hidden" name="doc_type" value="<?=h($type)?>">

  <div class="row g-3">
    <div class="col-md-4">
      <div class="d-flex justify-content-between align-items-center">
        <label class="form-label mb-0"><?=$type==='PAGAR'?'Fornecedor':'Cliente'?> (obrigatório)</label>
        <div class="d-flex gap-2 align-items-center">
          <button type="button" class="btn btn-sm btn-outline-dark" id="btnRefreshParties" title="Atualizar lista"><i class="bi bi-arrow-repeat"></i></button>
          <a class="small" href="parties.php?action=new&pref=<?= $type==='PAGAR'?'FORNECEDOR':'CLIENTE' ?>" target="_blank">+ cadastrar</a>
        </div>
      </div>
      <select class="form-select" name="counterparty_id" required>
        <option value="">Selecione...</option>
        <?php foreach ($parties as $p): ?>
          <option value="<?=$p['id']?>" <?= ($prefPartyId>0 && (int)$p['id']===$prefPartyId) ? 'selected' : '' ?>><?=h($p['name'])?></option>
        <?php endforeach; ?>
      </select>
      <div class="form-text">Se não existir, use “+ cadastrar”.</div>
    </div>

    <div class="col-md-4">
      <label class="form-label">Descrição</label>
      <input class="form-control" name="description" required>
    </div>

    <div class="col-md-4">
      <label class="form-label">Banco (obrigatório)</label>
      <select class="form-select" name="default_bank_id" required>
        <option value="">Selecione...</option>
        <?php foreach ($banks as $b): ?>
          <option value="<?=$b['id']?>"><?=h($b['bank_name'].' ('.$b['bank_number'].') Ag '.$b['agency'].' '.$b['account_type'])?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">Categoria (opcional)</label>
      <select class="form-select" name="category_id">
        <option value="">—</option>
        <?php foreach ($cats as $c): ?>
          <?php $ok = ($c['type']==='AMBOS' || $c['type']===$type); if (!$ok) continue; ?>
          <option value="<?=$c['id']?>"><?=h($c['name'])?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">Centro de Custo (opcional)</label>
      <select class="form-select" name="cost_center_id">
        <option value="">—</option>
        <?php foreach ($ccs as $cc): ?>
          <option value="<?=$cc['id']?>"><?=h($cc['name'])?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">Conta (Plano de Contas)</label>
      <select class="form-select" name="account_id">
        <option value="">—</option>
        <?php foreach ($accs as $a): ?>
          <option value="<?=$a['id']?>"><?=h($a['code'].' - '.$a['name'].' ('.$a['type'].')')?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-3">
      <label class="form-label">Nº Documento (opcional)</label>
      <input class="form-control" name="doc_number" placeholder="NF, Boleto, Contrato...">
    </div>

    <div class="col-md-6">
      <label class="form-label">Observação (opcional)</label>
      <input class="form-control" name="notes" placeholder="Complemento...">
    </div>

    <div class="col-md-2">
      <label class="form-label">Emissão</label>
      <input class="form-control" type="date" name="issue_date" value="<?=h(date('Y-m-d'))?>" required>
    </div>

    <div class="col-md-2">
      <label class="form-label">1º venc.</label>
      <input class="form-control" type="date" name="first_due_date" value="<?=h(date('Y-m-d'))?>" required>
    </div>

    <div class="col-md-3">
      <label class="form-label">Valor total</label>
      <input class="form-control" name="total_amount" data-money="brl" placeholder="R$ 0,00" required>
    </div>

    <div class="col-md-2">
      <label class="form-label">Parcelas</label>
      <input class="form-control" type="number" min="1" max="120" name="installments_count" value="1" required>
    </div>
  </div>

  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-primary">Salvar e gerar parcelas</button>
    <a class="btn btn-secondary" href="contas.php?type=<?=$type?>">Cancelar</a>
  </div>
</form>


<script>
(function(){
  const btn = document.getElementById('btnRefreshParties');
  const sel = document.querySelector('select[name="counterparty_id"]');
  if(!btn || !sel) return;

  btn.addEventListener('click', async () => {
    const old = sel.value;
    btn.disabled = true;
    btn.innerHTML = '<span class="spinner-border spinner-border-sm"></span>';
    try{
      const url = 'api_parties.php?type=<?= $type ?>';
      const res = await fetch(url, {headers: {'Accept':'application/json'}});
      const json = await res.json();
      if(!json.ok) throw new Error('Falha ao carregar');
      // rebuild options
      const items = json.items || [];
      sel.innerHTML = '<option value="">Selecione...</option>';
      for(const it of items){
        const opt = document.createElement('option');
        opt.value = it.id;
        opt.textContent = it.name;
        sel.appendChild(opt);
      }
      if (old) sel.value = old;
    }catch(e){
      alert('Não foi possível atualizar a lista.');
    }finally{
      btn.disabled = false;
      btn.innerHTML = '<i class="bi bi-arrow-repeat"></i>';
    }
  });
})();
</script>

<?php render_footer(); ?>
