<?php
require __DIR__.'/_init.php';
require_login();

$pdo=db();
$installmentId = (int)($_GET['installment_id'] ?? 0);

$st = $pdo->prepare("
  SELECT i.*, d.doc_type, d.counterparty_name, d.description
  FROM fin_installments i
  JOIN fin_documents d ON d.id=i.document_id
  WHERE i.id=?
");
$st->execute([$installmentId]);
$inst=$st->fetch();
if(!$inst){ render_header('Erro'); echo '<div class="alert alert-danger">Parcela não encontrada.</div>'; render_footer(); exit; }
$permKey = ($inst['doc_type']==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'view');

$rows = $pdo->prepare("
  SELECT s.*, b.bank_name, b.bank_number
  FROM fin_settlements s
  JOIN banks b ON b.id=s.bank_id
  WHERE s.installment_id=?
  ORDER BY s.occurred_at DESC
");
$rows->execute([$installmentId]);
$sets=$rows->fetchAll();

render_header('Baixas / Estornos');
?>
<h3 class="mb-3">Baixas / Estornos</h3>

<div class="card shadow-sm p-3 mb-3">
  <div><b><?=h($inst['doc_type'])?></b> — <?=h($inst['counterparty_name'])?> — <?=h($inst['description'])?></div>
  <div class="text-muted">
    Valor: R$ <?=h(number_format((float)$inst['amount'],2,',','.'))?> •
    Pago: R$ <?=h(number_format((float)$inst['paid_amount'],2,',','.'))?> •
    Status: <b><?=h($inst['status'])?></b>
  </div>
</div>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0 align-middle">
      <thead class="table-dark">
        <tr>
          <th>Data</th><th>Banco</th><th class="text-end">Valor</th><th>Obs</th><th>Status</th><th style="width:170px"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($sets as $s): ?>
          <tr>
            <td><?=h(date('d/m/Y H:i', strtotime($s['occurred_at'])))?></td>
            <td><?=h($s['bank_name'].' ('.$s['bank_number'].')')?></td>
            <td class="text-end">R$ <?=h(number_format((float)$s['amount'],2,',','.'))?></td>
            <td><?=h($s['note'] ?? '')?></td>
            <td>
              <?php if($s['reversed_at']): ?>
                <span class="badge bg-secondary">ESTORNADO</span>
              <?php else: ?>
                <span class="badge bg-success">ATIVO</span>
              <?php endif; ?>
            </td>
            <td class="text-end">
              <?php if(!$s['reversed_at']): ?>
                <a class="btn btn-sm btn-outline-danger" href="estornar_settlement.php?id=<?=$s['id']?>">Estornar</a>
              <?php endif; ?>
              <a class="btn btn-sm btn-outline-primary" href="contas.php?type=<?=$inst['doc_type']?>">Voltar</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$sets): ?>
          <tr><td colspan="6" class="text-center text-muted py-4">Sem baixas ainda.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php render_footer(); ?>
