<?php
require __DIR__.'/_init.php';
require_login();

$pdo = db();
$id = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("
  SELECT i.*, d.doc_type, d.counterparty_name, d.description
  FROM fin_installments i
  JOIN fin_documents d ON d.id=i.document_id
  WHERE i.id=?
");
$st->execute([$id]);
$inst = $st->fetch();
if (!$inst) { render_header('Erro'); echo '<div class="alert alert-danger">Parcela não encontrada.</div>'; render_footer(); exit; }
$permKey = ($inst['doc_type']==='PAGAR') ? 'contas_pagar' : 'contas_receber';
require_perm($permKey,'edit');

$banks = $pdo->query("SELECT id, bank_name, bank_number, agency, account_type FROM banks ORDER BY bank_name")->fetchAll();
$remaining = (float)$inst['amount'] - (float)$inst['paid_amount'];

$err='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_check();
  try {
    $bank_id = (int)($_POST['bank_id'] ?? 0);
    $val = money_to_decimal($_POST['amount'] ?? (string)$remaining);
    $note = trim($_POST['note'] ?? '');
    settlement_create((int)$inst['id'], $bank_id, $val, $note);
    redirect('/baixas.php?installment_id='.$inst['id']);
  } catch(Throwable $e) { $err=$e->getMessage(); }
}

render_header('Dar baixa (parcial)');
?>
<h3 class="mb-3">Dar baixa (parcial)</h3>

<div class="card shadow-sm p-3 mb-3">
  <div><span class="text-muted">Tipo:</span> <b><?=h($inst['doc_type'])?></b></div>
  <div><span class="text-muted">Pessoa:</span> <b><?=h($inst['counterparty_name'])?></b></div>
  <div><span class="text-muted">Descrição:</span> <b><?=h($inst['description'])?></b></div>
  <div><span class="text-muted">Vencimento:</span> <b><?=h(date('d/m/Y', strtotime($inst['due_date'])))?></b></div>
  <div class="d-flex gap-4">
    <div><span class="text-muted">Valor:</span> <b>R$ <?=h(number_format((float)$inst['amount'],2,',','.'))?></b></div>
    <div><span class="text-muted">Pago:</span> <b>R$ <?=h(number_format((float)$inst['paid_amount'],2,',','.'))?></b></div>
    <div><span class="text-muted">Restante:</span> <b>R$ <?=h(number_format($remaining,2,',','.'))?></b></div>
  </div>
</div>

<?php if ($err): ?><div class="alert alert-danger"><?=h($err)?></div><?php endif; ?>

<form method="post" class="card shadow-sm p-3">
  <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
  <div class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Banco (obrigatório)</label>
      <select class="form-select" name="bank_id" required>
        <?php foreach($banks as $b): ?>
          <option value="<?=$b['id']?>" <?=$b['id']==$inst['bank_id']?'selected':''?>>
            <?=h($b['bank_name'].' ('.$b['bank_number'].') Ag '.$b['agency'].' '.$b['account_type'])?>
          </option>
        <?php endforeach; ?>
      </select>
      <div class="form-text">Receber soma no saldo • Pagar subtrai do saldo</div>
    </div>
    <div class="col-md-3">
      <label class="form-label">Valor da baixa</label>
      <input class="form-control" name="amount" value="<?=h(number_format($remaining,2,',','.'))?>" data-money="brl" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">Obs (opcional)</label>
      <input class="form-control" name="note" placeholder="PIX, TED, etc.">
    </div>
  </div>
  <div class="mt-3 d-flex gap-2">
    <button class="btn btn-success">Confirmar</button>
    <a class="btn btn-secondary" href="contas.php?type=<?=$inst['doc_type']?>">Voltar</a>
  </div>
</form>
<?php render_footer(); ?>
