<?php
require __DIR__.'/_init.php';
require_login();
require_perm('assistant_ai','view');

use Dompdf\Dompdf;

$pdo=db();
$id=(int)($_GET['id'] ?? 0);

$st=$pdo->prepare("SELECT * FROM ai_reports WHERE id=? AND user_id=?");
$st->execute([$id, (int)$_SESSION['user_id']]);
$r=$st->fetch();
if(!$r){ http_response_code(404); die('Relatório não encontrado.'); }

$data=json_decode($r['result_json'], true) ?: [];
$appName=(string)setting_get('app.name','Financeiro');

$logoPath = (string)setting_get('app.logo_path','');
$logoDataUri = '';
if($logoPath){
  $abs = __DIR__ . $logoPath;
  if(file_exists($abs)){
    $mime = mime_content_type($abs);
    $b64 = base64_encode(file_get_contents($abs));
    $logoDataUri = "data:{$mime};base64,{$b64}";
  }
}

$score = (int)($data['score_saude_financeira'] ?? 0);
$class = h((string)($data['classificacao'] ?? ''));
$resumo = h((string)($data['resumo_executivo'] ?? ''));
$conclusao = h((string)($data['conclusao'] ?? ''));

$alerts = $data['alertas'] ?? [];
$recs = $data['recomendacoes_por_centro_custo'] ?? [];

$html = '<html><head><meta charset="utf-8">
<style>
body{font-family: DejaVu Sans, sans-serif; font-size:12px;}
h1{font-size:18px;margin:0 0 6px 0;}
h2{font-size:14px;margin:18px 0 8px 0;}
.small{color:#666}
.badge{display:inline-block;padding:4px 8px;border-radius:6px;background:#111;color:#fff;font-size:11px;}
.box{border:1px solid #ddd;border-radius:10px;padding:10px;margin:10px 0;}
</style></head><body>';

$html .= '<div style="display:flex;align-items:center;gap:12px;">';
if($logoDataUri) $html .= '<img src="'.$logoDataUri.'" style="height:42px;">';
$html .= '<div><h1>'.$appName.' — Relatório IA</h1><div class="small">Período: '.h($r['period_start']).' a '.h($r['period_end']).' • Provider: '.h($r['provider']).'</div></div></div>';

$html .= '<div class="box"><div class="small">Score</div><div style="font-size:26px;font-weight:bold;">'.$score.'</div><div class="badge">'.$class.'</div></div>';
$html .= '<div class="box"><h2>Resumo</h2><div>'.$resumo.'</div></div>';

$html .= '<div class="box"><h2>Alertas</h2><ul>';
foreach($alerts as $a){
  $t=h((string)($a['titulo'] ?? ''));
  $i=h((string)($a['impacto'] ?? ''));
  $ac=h((string)($a['acao'] ?? ''));
  $html .= "<li><b>{$t}</b> ({$i}) — {$ac}</li>";
}
if(!$alerts) $html .= '<li class="small">Sem alertas.</li>';
$html .= '</ul></div>';

$html .= '<div class="box"><h2>Recomendações por centro de custo</h2><ul>';
foreach($recs as $rc){
  $c=h((string)($rc['centro'] ?? ''));
  $a=h((string)($rc['acao'] ?? ''));
  $m=h((string)($rc['meta'] ?? ''));
  $html .= "<li><b>{$c}</b>: {$a} <span class='small'>({$m})</span></li>";
}
if(!$recs) $html .= '<li class="small">Sem recomendações específicas.</li>';
$html .= '</ul></div>';

$html .= '<div class="box"><h2>Conclusão</h2><div>'.$conclusao.'</div></div>';

$html .= '</body></html>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

header("Content-Type: application/pdf");
header('Content-Disposition: inline; filename="relatorio_ia.pdf"');
echo $dompdf->output();
