document.addEventListener("DOMContentLoaded", () => {
  document.body.classList.remove("no-js");
  // animações
  document.querySelectorAll(".btn").forEach(b => b.classList.add("btn-anim"));
  document.querySelectorAll(".btn").forEach(b => {
    if (!b.classList.contains("ripple-target")) b.classList.add("ripple-target");
  });

  const body = document.body;
  const overlay = document.getElementById("appOverlay");
  const btnSidebar = document.getElementById("btnSidebar");
  const btnCollapse = document.getElementById("btnCollapse");

  // Restore collapsed
  const collapsed = localStorage.getItem("sb-collapsed") === "1";
  if (collapsed) body.classList.add("sidebar-collapsed");

  // Mobile open/close
  const openSidebar = () => body.classList.add("sidebar-open");
  const closeSidebar = () => body.classList.remove("sidebar-open");

  btnSidebar?.addEventListener("click", () => {
    body.classList.contains("sidebar-open") ? closeSidebar() : openSidebar();
  });
  overlay?.addEventListener("click", closeSidebar);

  // Desktop collapse
  btnCollapse?.addEventListener("click", () => {
    body.classList.toggle("sidebar-collapsed");
    localStorage.setItem("sb-collapsed", body.classList.contains("sidebar-collapsed") ? "1" : "0");
  });

  // Theme toggle
  const root = document.documentElement;
  const themeToggle = document.getElementById("themeToggle");
  const themeIcon = document.getElementById("themeIcon");

  function applyTheme(theme){
    root.dataset.theme = theme;
    localStorage.setItem("theme", theme);
    if (themeIcon){
      themeIcon.className = theme === "light" ? "bi bi-sun" : "bi bi-moon-stars";
    }
  }
  applyTheme(localStorage.getItem("theme") || "dark");

  themeToggle?.addEventListener("click", () => {
    const cur = root.dataset.theme || "dark";
    applyTheme(cur === "dark" ? "light" : "dark");
  });

  // Submenus
  document.querySelectorAll("[data-group-btn]").forEach(btn => {
    btn.addEventListener("click", () => {
      const group = btn.closest(".nav-group");
      if (!group) return;
      group.classList.toggle("open");
    });
  });

  // Sidebar search
  const sidebarSearch = document.getElementById("sidebarSearch");
  const nav = document.getElementById("sidebarNav");

  function filterNav(q){
    const query = (q || "").toLowerCase().trim();
    const links = nav?.querySelectorAll("a.nav-item-link") || [];
    links.forEach(a => {
      const text = (a.innerText || "").toLowerCase();
      a.style.display = !query || text.includes(query) ? "" : "none";
    });

    (nav?.querySelectorAll(".nav-group") || []).forEach(g => {
      if (!query){
        g.style.display = "";
        return;
      }
      const any = Array.from(g.querySelectorAll("a.nav-item-link")).some(a => a.style.display !== "none");
      g.style.display = any ? "" : "none";
      if (any) g.classList.add("open");
    });
  }

  sidebarSearch?.addEventListener("input", () => filterNav(sidebarSearch.value));

  // close sidebar on mobile when clicking a link
  nav?.addEventListener("click", (e) => {
    const a = e.target.closest("a");
    if (!a) return;
    if (window.innerWidth < 992) closeSidebar();
  });

  // Ripple effect
  function ripple(e){
    const el = e.currentTarget;
    const rect = el.getBoundingClientRect();
    const size = Math.max(rect.width, rect.height);
    const x = e.clientX - rect.left - size/2;
    const y = e.clientY - rect.top - size/2;

    const span = document.createElement("span");
    span.className = "ripple-span";
    span.style.width = span.style.height = size + "px";
    span.style.left = x + "px";
    span.style.top = y + "px";

    el.appendChild(span);
    span.addEventListener("animationend", () => span.remove());
  }

  document.querySelectorAll(".ripple-target").forEach(el => {
    el.addEventListener("click", ripple);
  });
});

// COUNTUP + TILT (dashboard futurista)
(function(){
  function formatBR(value){
    // value is number
    try{
      return "R$ " + value.toLocaleString("pt-BR", {minimumFractionDigits: 2, maximumFractionDigits: 2});
    }catch(e){
      return "R$ " + value.toFixed(2);
    }
  }

  function animateCount(el, to, duration=900){
    const start = performance.now();
    const from = 0;
    const sign = to < 0 ? -1 : 1;
    const absTo = Math.abs(to);

    function frame(t){
      const p = Math.min(1, (t - start) / duration);
      const eased = 1 - Math.pow(1 - p, 3); // easeOutCubic
      const val = (from + absTo * eased) * sign;
      el.textContent = formatBR(val);
      if (p < 1) requestAnimationFrame(frame);
      else el.textContent = formatBR(to);
    }
    requestAnimationFrame(frame);
  }

  // Run once when page loads
  document.querySelectorAll("[data-countup]").forEach(el => {
    const raw = el.getAttribute("data-countup") || "0";
    const num = Number(raw);
    if (!Number.isFinite(num)) return;
    animateCount(el, num, 950);
  });

  // Tilt effect
  function onMove(e){
    const card = e.currentTarget;
    const rect = card.getBoundingClientRect();
    const x = (e.clientX - rect.left) / rect.width - 0.5;
    const y = (e.clientY - rect.top) / rect.height - 0.5;
    const rx = (-y * 6).toFixed(2);
    const ry = (x * 10).toFixed(2);
    card.style.transform = `perspective(900px) rotateX(${rx}deg) rotateY(${ry}deg) translateY(-1px)`;
  }
  function onLeave(e){
    const card = e.currentTarget;
    card.style.transform = "";
  }
  document.querySelectorAll("[data-tilt]").forEach(card => {
    card.addEventListener("mousemove", onMove);
    card.addEventListener("mouseleave", onLeave);
  });
})();


// DASH HOTKEYS (Alt+1..4)
(function(){
  document.addEventListener("keydown", (e) => {
    if (!e.altKey) return;
    const key = e.key;
    if (!["1","2","3","4","5"].includes(key)) return;
    const el = document.querySelector(`[data-hotkey="${key}"]`);
    if (!el) return;
    try { e.preventDefault(); } catch(_){}
    const href = el.getAttribute("data-href") || el.getAttribute("href");
    if (href) window.location.href = href;
  });
})();


// MASKS CPF/CNPJ + PHONE + CEP (vanilla)
(function(){
  function onlyDigits(s){ return (s||"").replace(/\D+/g,''); }

  function maskCPF_CNPJ(value){
    const d = onlyDigits(value);
    if (d.length <= 11){
      // CPF: 000.000.000-00
      return d
        .replace(/(\d{3})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d)/, '$1.$2')
        .replace(/(\d{3})(\d{1,2})$/, '$1-$2');
    }
    // CNPJ: 00.000.000/0000-00
    return d
      .replace(/(\d{2})(\d)/, '$1.$2')
      .replace(/(\d{3})(\d)/, '$1.$2')
      .replace(/(\d{3})(\d)/, '$1/$2')
      .replace(/(\d{4})(\d{1,2})$/, '$1-$2');
  }

  function maskPhone(value){
    const d = onlyDigits(value).slice(0, 11);
    if (d.length <= 10){
      // (00) 0000-0000
      return d
        .replace(/(\d{2})(\d)/, '($1) $2')
        .replace(/(\d{4})(\d{1,4})$/, '$1-$2');
    }
    // (00) 00000-0000
    return d
      .replace(/(\d{2})(\d)/, '($1) $2')
      .replace(/(\d{5})(\d{1,4})$/, '$1-$2');
  }

  function maskCEP(value){
    const d = onlyDigits(value).slice(0, 8);
    return d.replace(/(\d{5})(\d{1,3})$/, '$1-$2');
  }

  function bindMask(sel, fn){
    document.querySelectorAll(sel).forEach(inp=>{
      inp.addEventListener('input', () => {
        const start = inp.selectionStart;
        inp.value = fn(inp.value);
        try{ inp.setSelectionRange(start, start); }catch(_){}
      });
      inp.value = fn(inp.value);
    });
  }

  // parties.php fields
  bindMask('input[name="doc"]', maskCPF_CNPJ);
  bindMask('input[name="phone"]', maskPhone);
  bindMask('input[name="zip_code"]', maskCEP);
})();


// LIST VIEW TOGGLE (grid / compact) + enhanced tilt
(function(){
  // Apply saved view
  const saved = localStorage.getItem("list-view") || "grid";
  document.documentElement.dataset.listview = saved;
  document.querySelectorAll("[data-listview-btn]").forEach(b=> b.classList.toggle("active", b.getAttribute("data-listview-btn")===saved));

  // Buttons toggle
  document.querySelectorAll("[data-listview-btn]").forEach(btn=>{
    btn.addEventListener("click", ()=>{
      const mode = btn.getAttribute("data-listview-btn");
      if (!mode) return;
      document.documentElement.dataset.listview = mode;
      localStorage.setItem("list-view", mode);
      // update active state
      document.querySelectorAll("[data-listview-btn]").forEach(b=> b.classList.toggle("active", b.getAttribute("data-listview-btn")===mode));
    });
  });

  // Stronger tilt on list cards, softer on mobile
  const maxTilt = window.innerWidth < 768 ? 4 : 10;
  function onMove(e){
    const card = e.currentTarget;
    const rect = card.getBoundingClientRect();
    const x = (e.clientX - rect.left) / rect.width - 0.5;
    const y = (e.clientY - rect.top) / rect.height - 0.5;
    const rx = (-y * maxTilt * 0.65).toFixed(2);
    const ry = (x * maxTilt).toFixed(2);
    card.style.transform = `perspective(900px) rotateX(${rx}deg) rotateY(${ry}deg) translateY(-2px)`;
  }
  function onLeave(e){
    e.currentTarget.style.transform = "";
  }
  document.querySelectorAll(".list-card[data-tilt]").forEach(card=>{
    card.addEventListener("mousemove", onMove);
    card.addEventListener("mouseleave", onLeave);
  });
})();


// BRL MONEY MASK (R$ 0,00) - caret + colar valores + separadores
(function(){
  function onlyDigits(s){ return (s||"").replace(/\D+/g,''); }
  function formatBRLFromDigits(d){
    d = d.replace(/^0+/, '') || '0';
    if (d.length === 1) d = '0' + d;
    if (d.length === 2) d = '0' + d;
    const cents = d.slice(-2);
    let intp = d.slice(0, -2);
    intp = intp.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    return 'R$ ' + intp + ',' + cents;
  }
  function countDigitsBeforePos(str, pos){
    let c=0; for(let i=0;i<pos && i<str.length;i++){ if(/\d/.test(str[i])) c++; } return c;
  }
  function caretPosForDigitIndex(formatted, digitIndex){
    const minPos = formatted.startsWith('R$ ') ? 3 : 0;
    if (digitIndex <= 0) return minPos;
    let c=0;
    for (let i=0;i<formatted.length;i++){
      if(/\d/.test(formatted[i])){ c++; if(c>=digitIndex) return Math.max(minPos,i+1); }
    }
    return formatted.length;
  }
  function normalizeWithCaret(inp){
    const oldVal = inp.value || '';
    const pos = inp.selectionStart ?? oldVal.length;
    const digitIndex = countDigitsBeforePos(oldVal, pos);
    const d = onlyDigits(oldVal);
    const formatted = formatBRLFromDigits(d);
    inp.value = formatted;
    const newPos = caretPosForDigitIndex(formatted, digitIndex);
    try { inp.setSelectionRange(newPos, newPos); } catch(_){}
  }
  function parseClipboardToDigits(text){
    let t=(text||'').toString().trim();
    if(!t) return '';
    t=t.replace(/R\$\s?/gi,'').trim();
    if(t.includes(',')){
      const parts=t.split(',');
      const decRaw=parts.pop()||'';
      const intRaw=parts.join(',');
      const intD=onlyDigits(intRaw);
      let decD=onlyDigits(decRaw).slice(0,2);
      if(decD.length===0) decD='00';
      if(decD.length===1) decD=decD+'0';
      return (intD||'0')+decD;
    }
    const lastDot=t.lastIndexOf('.');
    if(lastDot!==-1){
      const after=t.slice(lastDot+1);
      const before=t.slice(0,lastDot);
      if(/^\d{2}$/.test(after.trim())){
        const intD=onlyDigits(before);
        const decD=onlyDigits(after).slice(0,2);
        return (intD||'0')+(decD||'00');
      }
      const allD=onlyDigits(t); if(!allD) return '';
      return allD+'00';
    }
    const d=onlyDigits(t); if(!d) return '';
    return d+'00';
  }
  function replaceDigits(baseDigits, startIdx, endIdx, insertDigits){
    startIdx=Math.max(0,startIdx);
    endIdx=Math.max(startIdx,endIdx);
    return baseDigits.slice(0,startIdx)+insertDigits+baseDigits.slice(endIdx);
  }
  function bindMoney(inp){
    if(!inp || inp.dataset.moneyBound==='1') return;
    inp.dataset.moneyBound='1';
    if(!inp.placeholder) inp.placeholder='R$ 0,00';
    if(inp.value) normalizeWithCaret(inp);
    inp.addEventListener('focus', ()=>{ if(!inp.value){ inp.value='R$ 0,00'; } });
    inp.addEventListener('keydown', (e)=>{
      const allowed=['Backspace','Delete','Tab','ArrowLeft','ArrowRight','Home','End'];
      if(allowed.includes(e.key)) return;
      if(e.ctrlKey||e.metaKey) return;
      if(/^\d$/.test(e.key)) return;
      if(e.key===','||e.key==='.') return;
      e.preventDefault();
    });
    inp.addEventListener('paste', (e)=>{
      try{
        const clip=(e.clipboardData||window.clipboardData).getData('text');
        const ins=parseClipboardToDigits(clip);
        if(!ins) return;
        e.preventDefault();
        const oldVal=inp.value||'R$ 0,00';
        const baseDigits=onlyDigits(oldVal);
        const selStart=inp.selectionStart ?? oldVal.length;
        const selEnd=inp.selectionEnd ?? selStart;
        const dStart=countDigitsBeforePos(oldVal, selStart);
        const dEnd=countDigitsBeforePos(oldVal, selEnd);
        const newDigits=replaceDigits(baseDigits, dStart, dEnd, ins);
        const formatted=formatBRLFromDigits(newDigits);
        inp.value=formatted;
        const newDigitIndex=dStart+ins.length;
        const caret=caretPosForDigitIndex(formatted, newDigitIndex);
        try{ inp.setSelectionRange(caret, caret); }catch(_){}
      }catch(_){}
    });
    inp.addEventListener('input', ()=>normalizeWithCaret(inp));
  }
  document.querySelectorAll('input[data-money="brl"]').forEach(bindMoney);
  const nameRe=/(^|_)(amount|total_amount|initial_balance|settled_amount)$/i;
  document.querySelectorAll('input').forEach(inp=>{
    const nm=(inp.getAttribute('name')||'').trim();
    const tp=(inp.getAttribute('type')||'text').toLowerCase();
    if(!nm) return;
    if(!nameRe.test(nm)) return;
    if(tp==='number'||tp==='date'||tp==='month') return;
    if(inp.dataset.money==='brl'){ bindMoney(inp); return; }
    inp.dataset.money='brl';
    bindMoney(inp);
  });
})();


// AUTO-APPLY MONEY MASK
