<?php
require __DIR__ . '/_init.php';
require_login();
require_role('admin','finance');
require_perm('accounts','view');

$pdo = db();
$action = $_GET['action'] ?? 'list';
$msg = $_GET['msg'] ?? '';
$err = '';

function accounts_list(PDO $pdo): array {
  return $pdo->query("SELECT * FROM fin_accounts ORDER BY code")->fetchAll();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  try {
    if ($action === 'create') { require_perm('accounts','create');
      $code = trim($_POST['code'] ?? '');
      $name = trim($_POST['name'] ?? '');
      $type = $_POST['type'] ?? 'DESPESA';
      $parent_id = (int)($_POST['parent_id'] ?? 0);

      if ($code==='' || $name==='') throw new Exception('Informe código e nome.');
      if (!in_array($type, ['RECEITA','DESPESA','ATIVO','PASSIVO','PATRIMONIO'], true)) $type='DESPESA';

      $pdo->prepare("INSERT INTO fin_accounts (code, name, type, parent_id) VALUES (?,?,?,?)")
          ->execute([$code, $name, $type, $parent_id>0?$parent_id:null]);

      audit_log('create','account',$pdo->lastInsertId(),['code'=>$code]);
      redirect('/accounts.php?msg=Conta criada');
    }

    if ($action === 'edit') { require_perm('accounts','edit');
      $id = (int)($_POST['id'] ?? 0);
      $code = trim($_POST['code'] ?? '');
      $name = trim($_POST['name'] ?? '');
      $type = $_POST['type'] ?? 'DESPESA';
      $parent_id = (int)($_POST['parent_id'] ?? 0);
      $is_active = (int)($_POST['is_active'] ?? 1);

      if ($code==='' || $name==='') throw new Exception('Informe código e nome.');
      if (!in_array($type, ['RECEITA','DESPESA','ATIVO','PASSIVO','PATRIMONIO'], true)) $type='DESPESA';
      if ($parent_id === $id) $parent_id = 0;

      $pdo->prepare("UPDATE fin_accounts SET code=?, name=?, type=?, parent_id=?, is_active=?, updated_at=NOW() WHERE id=?")
          ->execute([$code,$name,$type,$parent_id>0?$parent_id:null,$is_active,$id]);

      audit_log('edit','account',$id,[]);
      redirect('/accounts.php?msg=Conta atualizada');
    }
  } catch(Throwable $e) {
    $err = $e->getMessage();
  }
}

render_header('Plano de Contas');
if ($msg) echo '<div class="alert alert-success">'.h($msg).'</div>';
if ($err) echo '<div class="alert alert-danger">'.h($err).'</div>';

$all = accounts_list($pdo);

if ($action === 'new') { ?>
  <h3>Nova Conta</h3>
  <form method="post" action="accounts.php?action=create" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <div class="row g-3">
      <div class="col-md-2">
        <label class="form-label">Código</label>
        <input class="form-control" name="code" required>
      </div>
      <div class="col-md-5">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Tipo</label>
        <select class="form-select" name="type" required>
          <option value="RECEITA">RECEITA</option>
          <option value="DESPESA" selected>DESPESA</option>
          <option value="ATIVO">ATIVO</option>
          <option value="PASSIVO">PASSIVO</option>
          <option value="PATRIMONIO">PATRIMÔNIO</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Pai (op.)</label>
        <select class="form-select" name="parent_id">
          <option value="0">—</option>
          <?php foreach($all as $a): ?>
            <option value="<?=$a['id']?>"><?=h($a['code'].' '.$a['name'])?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="accounts.php">Cancelar</a>
    </div>
  </form>
<?php render_footer(); exit; }

if ($action === 'editform') {
  $id = (int)($_GET['id'] ?? 0);
  $st = $pdo->prepare("SELECT * FROM fin_accounts WHERE id=?");
  $st->execute([$id]);
  $a = $st->fetch();
  if (!$a) { echo '<div class="alert alert-danger">Conta não encontrada.</div>'; render_footer(); exit; }
  ?>
  <h3>Editar Conta</h3>
  <form method="post" action="accounts.php?action=edit" class="card shadow-sm p-3">
    <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
    <input type="hidden" name="id" value="<?=h((string)$a['id'])?>">
    <div class="row g-3">
      <div class="col-md-2">
        <label class="form-label">Código</label>
        <input class="form-control" name="code" value="<?=h($a['code'])?>" required>
      </div>
      <div class="col-md-5">
        <label class="form-label">Nome</label>
        <input class="form-control" name="name" value="<?=h($a['name'])?>" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Tipo</label>
        <select class="form-select" name="type" required>
          <?php $types=['RECEITA','DESPESA','ATIVO','PASSIVO','PATRIMONIO']; foreach($types as $t): ?>
            <option value="<?=$t?>" <?=$a['type']===$t?'selected':''?>><?=$t?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">Ativa?</label>
        <select class="form-select" name="is_active">
          <option value="1" <?=$a['is_active']?'selected':''?>>Sim</option>
          <option value="0" <?=!$a['is_active']?'selected':''?>>Não</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Pai (op.)</label>
        <select class="form-select" name="parent_id">
          <option value="0">—</option>
          <?php foreach($all as $p): if((int)$p['id']===(int)$a['id']) continue; ?>
            <option value="<?=$p['id']?>" <?=((int)$a['parent_id']===(int)$p['id'])?'selected':''?>>
              <?=h($p['code'].' '.$p['name'])?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Salvar</button>
      <a class="btn btn-secondary" href="accounts.php">Voltar</a>
    </div>
  </form>
<?php render_footer(); exit; }

?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Plano de Contas</h3>
  
  <div class="listview-toggle">
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="grid" title="Grade"><i class="bi bi-grid-3x3-gap"></i></button>
    <button type="button" class="btn btn-outline-dark ripple-target" data-listview-btn="compact" title="Compacto"><i class="bi bi-list"></i></button>
  </div>
<?php if (perm_can('accounts','create')): ?>
<a class="btn btn-primary" href="accounts.php?action=new">+ Nova Conta</a>
<?php endif; ?>
</div>

<div class="card shadow-sm">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead class="table-dark">
        <tr><th>Código</th><th>Nome</th><th>Tipo</th><th>Status</th><th style="width:140px"></th></tr>
      </thead>
      <tbody>
        <?php foreach($all as $a): ?>
          <tr>
            <td><?=h($a['code'])?></td>
            <td><?=h($a['name'])?></td>
            <td><?=h($a['type'])?></td>
            <td><?= $a['is_active'] ? '<span class="badge bg-success glow-badge">Ativa</span>' : '<span class="badge bg-secondary">Inativa</span>' ?></td>
            <td class="text-end"><?php if (perm_can('accounts','edit')): ?>
<a class="btn btn-sm btn-outline-primary" href="accounts.php?action=editform&id=<?=$a['id']?>">Editar</a>
<?php endif; ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$all): ?><tr><td colspan="5" class="text-center text-muted py-4">Nenhuma conta.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php render_footer(); ?>
