<?php
// app/perm_history.php
function perm_history_log(string $subject_type, int $subject_id, string $source, array $snapshot): void {
  try {
    $pdo = db();
    $changedBy = $_SESSION['user_id'] ?? null;
    $pdo->prepare("
      INSERT INTO perm_history (subject_type, subject_id, changed_by_user_id, source, snapshot_json)
      VALUES (?,?,?,?,?)
    ")->execute([
      $subject_type,
      $subject_id,
      $changedBy ? (int)$changedBy : null,
      $source,
      json_encode($snapshot, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
    ]);
  } catch (Throwable $e) {}
}
