<?php
// app/audit.php
function audit_log(string $action, string $entity, $entity_id=null, array $meta=[]): void {
  try {
    if (!function_exists('db')) return;
    $pdo = db();
    $uid = $_SESSION['user_id'] ?? null;
    $ip = $_SERVER['REMOTE_ADDR'] ?? null;
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? null;
    $metaJson = $meta ? json_encode($meta, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) : null;

    $pdo->prepare("
      INSERT INTO audit_logs (user_id, action, entity, entity_id, meta_json, ip, user_agent)
      VALUES (?,?,?,?,?,?,?)
    ")->execute([
      $uid ? (int)$uid : null,
      $action,
      $entity,
      $entity_id !== null ? (string)$entity_id : null,
      $metaJson,
      $ip,
      $ua ? mb_substr($ua,0,255,'UTF-8') : null
    ]);
  } catch (Throwable $e) {
    // silencioso
  }
}
