<?php
// app/mailer.php
use PHPMailer\PHPMailer\PHPMailer;

require_once __DIR__ . '/../vendor/autoload.php';

function mailer_send(string $toEmail, string $toName, string $subject, string $html): void {
  $mail = new PHPMailer(true);

  $host = (string)setting_get('smtp.host','');
  $user = (string)setting_get('smtp.user','');
  $pass = (string)setting_get('smtp.pass','');
  $port = (int)setting_get('smtp.port','587');
  $secure = (string)setting_get('smtp.secure','tls'); // tls/ssl/''

  $from = (string)setting_get('smtp.from_email','no-reply@site.com');
  $fromName = (string)setting_get('smtp.from_name','Financeiro');

  $mail->isSMTP();
  $mail->Host = $host;
  $mail->SMTPAuth = true;
  $mail->Username = $user;
  $mail->Password = $pass;
  $mail->Port = $port;
  if ($secure) $mail->SMTPSecure = $secure;

  $mail->setFrom($from, $fromName);
  $mail->addAddress($toEmail, $toName);

  $mail->isHTML(true);
  $mail->Subject = $subject;
  $mail->Body = $html;

  $mail->send();
}
