<?php
// app/auth.php
function load_user_permissions(int $userId): array {
  $pdo = db();
  $st = $pdo->prepare("SELECT perm_key, can_view, can_create, can_edit, can_delete FROM user_permissions WHERE user_id=?");
  $st->execute([$userId]);
  $perms = [];
  foreach ($st->fetchAll() as $r) {
    $perms[$r['perm_key']] = [
      'view' => (int)$r['can_view'] === 1,
      'create' => (int)$r['can_create'] === 1,
      'edit' => (int)$r['can_edit'] === 1,
      'delete' => (int)$r['can_delete'] === 1,
    ];
  }
  return $perms;
}

function require_login(): void {
  if (empty($_SESSION['user_id'])) redirect('/login.php');
}

function require_role(string ...$roles): void {
  $r = $_SESSION['user_role'] ?? '';
  if (!$r || !in_array($r, $roles, true)) {
    http_response_code(403);
    die('Sem permissão.');
  }
}

function login_attempt(string $email, string $password): bool {
  $pdo = db();
  $stmt = $pdo->prepare("SELECT id, name, role, password_hash, is_active FROM users WHERE email = ? LIMIT 1");
  $stmt->execute([$email]);
  $u = $stmt->fetch();
  if (!$u || (int)$u['is_active'] !== 1) return false;
  if (!password_verify($password, $u['password_hash'])) return false;

  $_SESSION['user_id'] = (int)$u['id'];
  $_SESSION['user_name'] = $u['name'];
  $_SESSION['user_role'] = $u['role'] ?? 'read';
  $_SESSION['perms'] = load_user_permissions((int)$u['id']);
  return true;
}
