<?php
// app/ai/openai_client.php
function openai_generate_text(string $model, string $prompt, float $temperature=0.2): string {
  $key = setting_get('openai.api_key','');
  if (!$key) throw new Exception('OpenAI API key não configurada.');

  $payload = [
    "model" => $model,
    "input" => $prompt,
    "temperature" => $temperature,
  ];

  $ch = curl_init("https://api.openai.com/v1/responses");
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
      "Authorization: Bearer {$key}",
      "Content-Type: application/json",
    ],
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_TIMEOUT => 60,
  ]);

  $res = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($res === false) throw new Exception('Falha OpenAI: '.curl_error($ch));
  curl_close($ch);

  if ($code < 200 || $code >= 300) throw new Exception("OpenAI HTTP {$code}: {$res}");

  $json = json_decode($res, true);
  $text = '';
  foreach (($json['output'] ?? []) as $o) {
    foreach (($o['content'] ?? []) as $c) {
      if (($c['type'] ?? '') === 'output_text') $text .= ($c['text'] ?? '');
    }
  }
  return trim($text);
}
