<?php
// app/ai/gemini_client.php
function gemini_generate_text(string $model, string $prompt): string {
  $key = setting_get('gemini.api_key','');
  if (!$key) throw new Exception('Gemini API key não configurada.');

  $url = "https://generativelanguage.googleapis.com/v1beta/models/{$model}:generateContent";

  $payload = [
    "contents" => [
      ["parts" => [["text" => $prompt]]]
    ]
  ];

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
      "Content-Type: application/json",
      "x-goog-api-key: {$key}",
    ],
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_TIMEOUT => 60,
  ]);

  $res = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  if ($res === false) throw new Exception('Falha Gemini: '.curl_error($ch));
  curl_close($ch);

  if ($code < 200 || $code >= 300) throw new Exception("Gemini HTTP {$code}: {$res}");

  $json = json_decode($res, true);
  $text = $json['candidates'][0]['content']['parts'][0]['text'] ?? '';
  return trim($text);
}
