<?php
// app/ai/json_tools.php
function extract_first_json_object(string $s): array {
  $start = strpos($s, '{');
  $end = strrpos($s, '}');
  if ($start === false || $end === false || $end <= $start) {
    throw new Exception('IA não retornou JSON válido.');
  }
  $json = substr($s, $start, $end - $start + 1);
  $arr = json_decode($json, true);
  if (!is_array($arr)) throw new Exception('JSON inválido: '.json_last_error_msg());
  return $arr;
}
