# Financeiro Pro v3 (PHP + MySQL)

## Requisitos
- PHP 8.1+ (com extensões: pdo_mysql, openssl, curl, fileinfo)
- MySQL/MariaDB
- Composer

## Instalação rápida
1) Crie o banco e tabelas:
   - Importe `schema.sql` no MySQL.

2) Configure `app/config.php`
   - Ajuste host/user/pass do MySQL
   - Defina `app_key` (string secreta grande)

3) Dependências:
   - `composer install`

4) Crie um admin:
   - `php create_admin.php`
   - Login padrão exibido no terminal.

5) Servidor:
   - Aponte a raiz web para a pasta `public/`
   - Ou rode `php -S 127.0.0.1:8000 -t public`

## Primeiros passos no sistema
- Faça login
- Cadastre 1 banco (com saldo inicial)
- Cadastre categorias / centros / plano de contas (opcional)
- Crie lançamentos (pagar/receber) com parcelas
- Use:
  - Baixa parcial / estorno (menu de parcelas)
  - Conciliação bancária (importar CSV e auto-match)
  - Assistente IA (configurar chaves em Configurações e gerar PDF)

## CSV de conciliação
Formato (com ou sem header):
`date,amount,description,external_id`
Exemplos de date aceitos:
- `2026-02-01`
- `01/02/2026`

## Segurança
- Chaves OpenAI/Gemini e senha SMTP são guardadas criptografadas em `app_settings`.
- Nunca exponha as chaves no front-end.


## Clientes / Fornecedores
- Cadastre em **Cadastros > Clientes/Fornecedores**.
- Ao criar Contas a Pagar/Receber, selecione o fornecedor/cliente cadastrado.

- Importação: **Cadastros > Importar CSV**.


## Usuários, permissões e prompts
- Para instalações existentes, rode: `migration_permissions_prompts.sql`.
- Para criar prompt padrão, rode: `seed_prompts.sql`.
- Configuração de IA: menu **IA > Config IA (APIs)**.
- Perfil: ícone no topo.


## Perfis padrão de permissões (Admin/Financeiro/Leitura)
1) Crie as estruturas (se ainda não existir):
- Rode `migration_all_admin_ia.sql` (ou as migrations específicas do projeto)

2) Crie os 3 perfis padrão:
- Rode `seed_permission_profiles.sql`

3) Aplicar perfil a um usuário (opcional via SQL):
- Veja `apply_profile_to_user.sql`
